/***********************************************************
 * $Id$
 * 
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 19.09.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/
package org.clazzes.login.adapter.http.i18n;

import java.util.ListResourceBundle;

/**
 * German translations.
 */
public class Messages_de extends ListResourceBundle {

    @Override
    protected Object[][] getContents() {

        return new Object[][] {
            { "user", "Benutzer" },
            { "password", "Passwort" },
            { "token-otp", "YubiKey OTP" },
            { "ephemeral-otp", "SMS OTP" },
            { "domainUserTitle", "Bitte geben Sie den Benutzer in der Dom\u00E4ne \"%s\" oder den Benutzer einer anderen Dom\u00E4ne im Format \"Benutzer@Dom\u00E4ne\" oder \"Dom\u00E4ne/Benutzer\" ein." },
            { "domainUserPlaceholder", "Benutzer@Dom\u00E4ne" },
            { "enter-user-and-password", "Geben Sie bitte Dom\u00E4ne, Benutzer und Passwort ein." },
            { "enter-token-otp", "Geben Sie bitte den YubiKey OTP ein, indem Sie die Kontaktfläche auf Ihrem Token drücken." },
            { "enter-ephemeral-otp", "Geben Sie bitte den OTP sein, welchen Sie per SMS erhalten haben." },
            { "user-or-password-invalid", "Der eingegebene Benutzer oder das Passwort sind ung\u00FCltig." },
            { "valid-certificate-expired", "Das Zertifikat ist abgelaufen."},
            { "no-valid-certificate", "Der Benutzer hat kein gültiges Zertifikat." },
            { "too-many-retries", "Die Anmeldung wurde aufgrund zu vieler erfolgloser Versuche blockiert." },
            { "login-ok", "Anmeldung erfolgreich." },
            { "do-login", "Anmelden"},
            { "do-logout", "Abmelden" },
            { "do-generate-otp", "SMS OTP generieren" },
            { "checkingCredentials", "Login-Daten werden gepr\u00FCft..."},
            { "generatingEphemeralOtp", "Senden des SMS OTP..."},
            { "loggingOut", "Sie werden abgemeldet..."},
            { "domainless.domainUserTitle", "Bitte geben Sie den Benutzer ein." },
            { "domainless.domainUserPlaceholder", "Benutzer" },
            { "domainless.enter-user-and-password", "Geben Sie bitte Benutzer und Passwort ein." },
            { "challengeDomainless.domainUserTitle", "Bitte geben Sie den Registrierungscode ein." },
            { "challengeDomainless.enter-user-and-password", "Geben Sie bitte Registrierungscode und Sicherheitscode ein." },
            { "challengeDomainless.domainUserPlaceholder", "Registrierungscode" },
            { "challengeDomainless.user", "Registrierungscode" },
            { "challengeDomainless.password", "Sicherheitscode" },
            { "emphemeralOtpSms.subject", "OTP für den Benutzer %s am Host %s" },
            { "emphemeralOtpSms.body", "OTP für den Benutzer %s am Host %s:\n%s" }			
        };
    }

}
