/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.clazzes.login.adapter.http.TokenGenerator;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.sec.PageTokenService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTokenServiceImpl
implements PageTokenService,
ManagedService {
    private static final Logger log = LoggerFactory.getLogger(PageTokenServiceImpl.class);
    private int sessionTimeout = 180;
    private int maxPageTokens = 5000;
    private TokenGenerator tokenGenerator;
    private final ConcurrentMap<String, Long> pageTokens = new ConcurrentHashMap<String, Long>();

    private Long makeExpirationTimestamp() {
        return System.currentTimeMillis() + (long)this.sessionTimeout * 60000L;
    }

    public String getPageToken(HttpServletRequest req) {
        String token = this.tokenGenerator.generateToken();
        if (log.isDebugEnabled()) {
            log.debug("Generated page token [{}] for client [{}].", (Object)token, (Object)RequestHelper.getRealRemoteIP((HttpServletRequest)req));
        }
        this.pageTokens.put(token, this.makeExpirationTimestamp());
        return token;
    }

    public boolean checkPageToken(HttpServletRequest req, String token) {
        boolean ret = this.pageTokens.containsKey(token);
        if (ret) {
            this.pageTokens.put(token, this.makeExpirationTimestamp());
            if (log.isDebugEnabled()) {
                log.debug("Successfully verified page token [{}] for client [{}].", (Object)token, (Object)RequestHelper.getRealRemoteIP((HttpServletRequest)req));
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Received invalid page token [{}] from client [{}].", (Object)token, (Object)RequestHelper.getRealRemoteIP((HttpServletRequest)req));
        }
        return ret;
    }

    public void gc() {
        int ntokens = this.pageTokens.size();
        if (log.isDebugEnabled()) {
            log.debug("Garbage collecting [{}] page tokens...", (Object)ntokens);
        }
        PriorityQueue<Map.Entry<String, Long>> watermarkQueue = null;
        ArrayList<String> tokensToDelete = null;
        if (ntokens > this.maxPageTokens) {
            if (log.isWarnEnabled()) {
                log.warn("The maximal number of [{}] page tokens has been exceeded, prematurely deleting tokens.", (Object)this.maxPageTokens);
            }
            tokensToDelete = new ArrayList<String>(10 + ntokens - this.maxPageTokens);
            watermarkQueue = new PriorityQueue<Map.Entry<String, Long>>(this.maxPageTokens + 1, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
        }
        long now = System.currentTimeMillis();
        Iterator it = this.pageTokens.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if ((Long)e.getValue() <= now) {
                if (log.isDebugEnabled()) {
                    log.debug("Page token [{}] has expired.", e.getKey());
                }
                it.remove();
                continue;
            }
            if (watermarkQueue == null) continue;
            watermarkQueue.add(e);
            if (watermarkQueue.size() <= this.maxPageTokens) continue;
            Map.Entry ed = (Map.Entry)watermarkQueue.poll();
            if (log.isWarnEnabled()) {
                long delta = (Long)ed.getValue() - now;
                log.warn(String.format(Locale.ENGLISH, "Page token [%s] deleted [%dh%d'%.3f\"] before expiry.", ed.getKey(), delta / 3600000L, delta / 60000L % 60L, (double)(delta % 60000L) * 0.001));
            }
            tokensToDelete.add((String)ed.getKey());
        }
        if (tokensToDelete != null) {
            for (String token : tokensToDelete) {
                this.pageTokens.remove(token);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished page token garbage collection with [{}] remaining page tokens.", (Object)this.pageTokens.size());
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        Object maxPageTokens_s;
        Object sessionTimeout_s;
        if (log.isDebugEnabled()) {
            log.debug("updated called: properties=[{}]", (Object)properties);
        }
        if ((sessionTimeout_s = properties.get("sessionTimeout")) != null) {
            this.sessionTimeout = Integer.parseInt(sessionTimeout_s.toString());
        }
        if ((maxPageTokens_s = properties.get("maxPageTokens")) != null) {
            this.maxPageTokens = Integer.parseInt(maxPageTokens_s.toString());
        }
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

