/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.clazzes.login.adapter.http.LoginInfoCache;
import org.clazzes.login.adapter.http.PageTokenServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    private LoginInfoCache loginInfoCache;
    private PageTokenServiceImpl pageTokenService;
    private ScheduledExecutorService executorService;
    private Future<?> future;

    private void cancelFuture() {
        if (this.future != null) {
            log.info("Stopping http-login-adapter garbage collection.");
            this.future.cancel(true);
            this.future = null;
        }
    }

    public void executorServiceBound(ScheduledExecutorService executorService) {
        this.cancelFuture();
        this.executorService = executorService;
        if (this.executorService != null) {
            long interval = 60L;
            log.info("Starting http-login-adapter garbage collection to be scheduled each [{}] seconds.", (Object)interval);
            this.future = this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    GarbageCollector.this.loginInfoCache.gc();
                    GarbageCollector.this.pageTokenService.gc();
                }
            }, interval, interval, TimeUnit.SECONDS);
        }
    }

    public void executorServiceUnbound(ScheduledExecutorService executorService) {
        this.cancelFuture();
        this.executorService = null;
    }

    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }

    public void setPageTokenService(PageTokenServiceImpl pageTokenService) {
        this.pageTokenService = pageTokenService;
    }
}

