/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.htpasswd.jaas;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HtpasswdFileHelper {
    public static Map<String, String> readHtpasswdFile(Reader file) throws IOException {
        Pattern entry = Pattern.compile("^([^:]+):(.+)");
        HashMap<String, String> htUsers = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                Matcher m;
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#") || !(m = entry.matcher(line)).matches()) continue;
                htUsers.put(m.group(1), m.group(2));
            }
        }
        return htUsers;
    }

    public static void writeHtpasswdFile(Writer file, Map<String, String> htUsers) throws IOException {
        try (Writer w = file;){
            ArrayList<String> users = new ArrayList<String>(htUsers.size());
            users.addAll(htUsers.keySet());
            Collections.sort(users);
            Pattern valid = Pattern.compile("[^\\p{Space}\\p{Cntrl}:]+");
            for (String user : users) {
                String hash = htUsers.get(user);
                if (!valid.matcher(user).matches()) {
                    throw new IllegalArgumentException("User [" + user + "] contains invalid characters");
                }
                if (!valid.matcher(hash).matches()) {
                    throw new IllegalArgumentException("Hash for user [" + user + "] contains invalid characters");
                }
                w.write(user);
                w.write(":");
                w.write(hash);
                w.write("\n");
            }
        }
    }
}

