/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.htpasswd.jaas;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;
import org.clazzes.login.htpasswd.jaas.HtpasswdFileHelper;
import org.clazzes.login.htpasswd.jaas.HtpasswdGroup;
import org.clazzes.login.htpasswd.jaas.IHtpasswdAuthService;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtpasswdAuthService
implements IHtpasswdAuthService {
    private static final Logger log = LoggerFactory.getLogger(HtpasswdAuthService.class);
    private final Map<String, String> htUsers = new HashMap<String, String>();
    private final Map<String, List<HtpasswdGroup>> htGroups = new HashMap<String, List<HtpasswdGroup>>();
    private final Map<String, Map<String, String>> htClaims = new HashMap<String, Map<String, String>>();
    private File htpasswdFile;
    private long lastModified;
    private File groupFile;
    private long groupLastModified;
    private File claimsFile;
    private long claimsLastModified;

    @Override
    public boolean authenticate(String username, char[] password) {
        String storedPwd = this.htUsers.get(username);
        boolean authenticated = false;
        if (storedPwd != null) {
            String passwd = new String(password);
            if (storedPwd.startsWith("$2y$")) {
                if (BCrypt.checkpw(passwd, storedPwd)) {
                    if (log.isDebugEnabled()) {
                        log.debug("BCrypt encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.startsWith("$apr1$")) {
                if (storedPwd.equals(Md5Crypt.apr1Crypt((String)passwd, (String)storedPwd))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Apache MD5 encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.startsWith("{SHA}")) {
                String passwd64 = Base64.encodeBase64String((byte[])DigestUtils.sha1((String)passwd));
                if (storedPwd.substring("{SHA}".length()).equals(passwd64)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unsalted SHA-1 encoded password matched for user [{}]", (Object)username);
                    }
                    authenticated = true;
                }
            } else if (storedPwd.equals(Crypt.crypt((String)passwd, (String)storedPwd))) {
                if (log.isDebugEnabled()) {
                    log.debug("Libc crypt encoded password matched for user [{}]", (Object)username);
                }
                authenticated = true;
            } else if (log.isDebugEnabled()) {
                log.debug("Password for user [{}] did not match", (Object)username);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("User [{}] not found in file [{}]", (Object)username, (Object)this.htpasswdFile);
        }
        return authenticated;
    }

    @Override
    public List<HtpasswdGroup> getUserGroups(String username) {
        List<HtpasswdGroup> groups = this.htGroups.get(username);
        if (groups == null) {
            return null;
        }
        return Collections.unmodifiableList(groups);
    }

    @Override
    public Map<String, String> getUserClaims(String username) {
        Map<String, String> claims = this.htClaims.get(username);
        if (claims == null) {
            return null;
        }
        return Collections.unmodifiableMap(claims);
    }

    public void readString(String fileContent) {
        this.htpasswdFile = null;
        this.htUsers.clear();
        this.lastModified = -1L;
        if (fileContent != null) {
            try (StringReader reader = new StringReader(fileContent);){
                this.htUsers.putAll(HtpasswdFileHelper.readHtpasswdFile(reader));
            }
            catch (IOException e) {
                log.error("Failed to read htpasswd file [{}]", (Object)fileContent, (Object)e);
            }
        }
    }

    public void read(File file) {
        this.htpasswdFile = file;
        this.htUsers.clear();
        if (this.htpasswdFile.exists()) {
            this.lastModified = this.htpasswdFile.lastModified();
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                this.htUsers.putAll(HtpasswdFileHelper.readHtpasswdFile(reader));
                log.info("Successfully read [{}] user entries from htpasswd file [{}]", (Object)this.htUsers.size(), (Object)this.htpasswdFile);
            }
            catch (Exception e) {
                log.error("Failed to read htpasswd file [" + String.valueOf(this.htpasswdFile) + "]", (Throwable)e);
            }
        } else {
            log.warn("htpasswd file [{}] does not exist.", (Object)this.htpasswdFile);
            this.lastModified = -1L;
        }
    }

    private void addUserToGroup(HtpasswdGroup gn, String user) {
        List<HtpasswdGroup> groups = this.htGroups.get(user);
        if (groups == null) {
            groups = new ArrayList<HtpasswdGroup>();
            this.htGroups.put(user, groups);
        }
        groups.add(gn);
    }

    private void readGroupReader(Reader file) {
        Pattern entry = Pattern.compile("^([^:]+):([^:]+)");
        try (Scanner scanner = new Scanner(file);){
            int ngroups = 0;
            while (scanner.hasNextLine()) {
                String[] users;
                Matcher m;
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#") || !(m = entry.matcher(line)).matches()) continue;
                HtpasswdGroup gn = new HtpasswdGroup(m.group(1));
                for (String user : users = m.group(2).trim().split("\\s*,\\s*")) {
                    if (user.isEmpty()) continue;
                    this.addUserToGroup(gn, user);
                }
                ++ngroups;
            }
        }
    }

    public void readGroupString(String fileContent) {
        this.groupFile = null;
        this.groupLastModified = -1L;
        this.htGroups.clear();
        if (fileContent != null) {
            try {
                this.readGroupReader(new StringReader(fileContent));
                log.info("Successfully read groups from group file [{}]", (Object)fileContent);
            }
            catch (Exception e) {
                log.error("Failed to read group file [{}]", (Object)fileContent, (Object)e);
            }
        }
    }

    public void readGroupFile(File file) {
        this.groupFile = file;
        this.htGroups.clear();
        if (this.groupFile != null && this.groupFile.exists()) {
            this.groupLastModified = this.groupFile.lastModified();
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                this.readGroupReader(reader);
                log.info("Successfully read groups from group file [{}]", (Object)this.groupFile);
            }
            catch (Exception e) {
                log.error("Failed to read group file [{}]", (Object)this.groupFile, (Object)e);
            }
        } else {
            log.warn("group file [{}] does not exist.", (Object)this.groupFile);
            this.groupLastModified = -1L;
        }
    }

    private void readClaimsReader(Reader reader) {
        Gson gson = new Gson();
        this.htClaims.putAll((Map)gson.fromJson(reader, new TypeToken<Map<String, Map<String, String>>>(){}.getType()));
    }

    public void readClaimsString(String fileContent) {
        this.claimsFile = null;
        this.claimsLastModified = -1L;
        this.htClaims.clear();
        if (fileContent != null) {
            try {
                this.readClaimsReader(new StringReader(fileContent));
                log.info("Successfully read [{}] entries from claims file [{}]", (Object)this.htClaims.size(), (Object)fileContent);
            }
            catch (Exception e) {
                log.error("Failed to read claims file [{}]", (Object)fileContent, (Object)e);
            }
        }
    }

    public void readClaimsFile(File file) {
        this.claimsFile = file;
        this.htClaims.clear();
        if (this.claimsFile != null && this.claimsFile.exists()) {
            this.claimsLastModified = this.claimsFile.lastModified();
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                this.readClaimsReader(reader);
                log.info("Successfully read [{}] entries from claims file [{}]", (Object)this.htClaims.size(), (Object)this.claimsFile);
            }
            catch (Exception e) {
                log.error("Failed to read claims file [{}]", (Object)this.claimsFile, (Object)e);
            }
        } else {
            log.warn("claims file [{}] does not exist.", (Object)this.claimsFile);
            this.claimsLastModified = -1L;
        }
    }

    public int getNumberHtpasswdUsers() {
        return this.htUsers.size();
    }

    public boolean needsUpdate() {
        if (this.htpasswdFile == null) {
            return false;
        }
        if (this.htpasswdFile.exists() ? this.htpasswdFile.lastModified() > this.lastModified : this.lastModified >= 0L) {
            return true;
        }
        if (this.groupFile == null) {
            return false;
        }
        if (this.groupFile.exists()) {
            return this.groupFile.lastModified() > this.groupLastModified;
        }
        if (this.groupLastModified >= 0L) {
            return true;
        }
        if (this.claimsFile == null) {
            return false;
        }
        if (this.claimsFile.exists()) {
            return this.claimsFile.lastModified() > this.claimsLastModified;
        }
        return this.claimsLastModified >= 0L;
    }

    public File getHtpasswdFile() {
        return this.htpasswdFile;
    }

    public File getGroupFile() {
        return this.groupFile;
    }

    public File getClaimsFile() {
        return this.claimsFile;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.htpasswdFile) + "]";
    }
}

