/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/

package org.clazzes.login.htpasswd.jaas;

import java.util.List;
import java.util.Map;

public interface IHtpasswdAuthService {

    /**
     * Authenticate a user based on a username and password.
     *
     * If the account is determined to be a local account, authentication
     * will be done against the locally stored password.
     * Otherwise, the configured htpasswd file is read. All current output options
     * of htpasswd are supported: clear text, crypt(), Apache MD5 and unsalted SHA-1.
     *
     * @param username The username.
     * @param password The password.
     * @return Whether the user/password combination is right.
     */
    boolean authenticate(String username, char[] password);

    /**
     * @param username The user to query the groups of.
     * @return The groups of the given user name read from the group file or
     *         <code>null</code>, if no group file exists.
     */
    List<HtpasswdGroup> getUserGroups(String username);

    /**
     * @param username The user to query the additional claim of.
     * @return The addtional claims of the given user name read from the claims
     *         file or <code>null</code>, if no claims file exists.
     */
    Map<String, String> getUserClaims(String username);

}