/***********************************************************
 * $Id$
 * 
 * htpasswd JAAS login module of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 21. März 2016
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.htpasswd.jaas;

import java.security.Principal;

/**
 * A principal returning the logged on user.
 */
public class HtpasswdPrincipal implements Principal {

    private final String name;
    private final String realm;
    
    public HtpasswdPrincipal(String name, String realm) {
        super();
        this.name = name;
        this.realm = realm;
    }

    /* (non-Javadoc)
     * @see java.security.Principal#getName()
     */
    @Override
    public String getName() {
        
        return this.name;
    }

    /**
     * @return The JAAS realm of the LoginService used to authenticate.
     */
    public String getRealm() {
        return this.realm;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((this.name == null) ? 0 : this.name.hashCode());
        result = prime * result + ((this.realm == null) ? 0 : this.realm.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HtpasswdPrincipal other = (HtpasswdPrincipal) obj;
        if (this.name == null) {
            if (other.name != null)
                return false;
        } else if (!this.name.equals(other.name))
            return false;
        if (this.realm == null) {
            if (other.realm != null)
                return false;
        } else if (!this.realm.equals(other.realm))
            return false;
        return true;
    }

}
