package org.clazzes.login.htpasswd.jaas;

import java.nio.file.attribute.GroupPrincipal;

/**
 * A group membership parsed from <code>&lt;realm&gt;.groups</code>
 */
public class HtpasswdGroup implements GroupPrincipal {

    private final String name;
    
    public HtpasswdGroup(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        
        return this.name;
    }

    @Override
    public String toString() {
        return "HtpasswdGroup[" + this.name + "]";
    }

}
