package org.clazzes.login.htpasswd.jaas;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class HtpasswdAuthServiceFactoryConfiguration {
    // Specify the directory used for the htpasswd files
    // The default uses the ${login.htpasswd.etcDir} or ${svg.runner.etcPath}/htpasswd.d from the system properties as the configuration directory.
    // Mutually exclusive with htpasswdFileContents
    private Path htpasswdDir;
    // Specify configuration files without actually having any on disk.
    // Mutually exclusive with htpasswdDir
    private Map<String, String> htpasswdFileContents;

    public HtpasswdAuthServiceFactoryConfiguration htpasswdDir(Path htpasswdDir) {
        if (this.htpasswdFileContents != null) {
            throw new IllegalStateException("htpasswdDir and htpasswdFileContents are mutually exclusive.");
        }

        this.htpasswdDir = htpasswdDir;

        return this;
    }

    public HtpasswdAuthServiceFactoryConfiguration htpasswdFileContents(Map<String, String> htpasswdFileContents) {
        if (this.htpasswdDir != null) {
            throw new IllegalStateException("htpasswdDir and htpasswdFileContents are mutually exclusive.");
        }

        // Ensure mutability for htpasswdFileContent().
        this.htpasswdFileContents = new HashMap<>(htpasswdFileContents);

        return this;
    }

    public HtpasswdAuthServiceFactoryConfiguration htpasswdFileContent(String fileName, String content) {
        if (this.htpasswdDir != null) {
            throw new IllegalStateException("htpasswdDir and htpasswdFileContents are mutually exclusive.");
        }

        if (this.htpasswdFileContents == null) {
            this.htpasswdFileContents = new HashMap<>();
        }

        this.htpasswdFileContents.put(fileName, content);

        return this;
    }



    public HtpasswdAuthServiceFactory build() {
        return new HtpasswdAuthServiceFactory(this);
    }

    public Path getHtpasswdDir() {
        return htpasswdDir;
    }

    public Map<String, String> getHtpasswdFileContents() {
        return htpasswdFileContents;
    }
}
