/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.Principal;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.clazzes.login.external.X509HttpLoginService;
import org.clazzes.util.http.ResponseHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509LoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(X509LoginServlet.class);
    private static final long serialVersionUID = -6824438139598839731L;
    private final HttpLoginService httpLoginService;

    protected X509LoginServlet(HttpLoginService httpLoginService) {
        this.httpLoginService = httpLoginService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pi = req.getPathInfo();
        if (pi != null && pi.startsWith("/ctx/")) {
            Principal principal = this.httpLoginService.checkLogin(req);
            if (principal == null) {
                resp.sendError(401);
                return;
            }
            boolean ok = this.httpLoginService.checkPermission(req, req.getRequestURI());
            if (ok) {
                try (ServletOutputStream os = resp.getOutputStream();
                     OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");){
                    w.write(StringEscapeUtils.builder((CharSequenceTranslator)StringEscapeUtils.ESCAPE_HTML4).append("<!doctype html>\n<html lang='en'>\n<head>\n<meta charset=utf-8>\n<title>X.509 Login</title>\n</head>\n<body>\n<p>Permission granted to [").escape(principal.getName()).append("]</p>\n</body>\n</html>").toString());
                    return;
                }
            }
            log.error("Permission denied to [{}] for [{}].", (Object)req.getRequestURI(), (Object)principal.getName());
            resp.sendError(403);
            return;
        }
        if ("/login".equals(pi)) {
            Principal principal = this.httpLoginService.checkLogin(req);
            if (principal == null) {
                log.error("Received unauthorized request to [{}].", (Object)req.getRequestURI());
                resp.sendError(401);
                return;
            }
            ResponseHelper.setNoCacheHeaders((HttpServletResponse)resp);
            resp.setContentType("text/html;charset=UTF-8");
            try (ServletOutputStream os = resp.getOutputStream();
                 OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");){
                w.write(StringEscapeUtils.builder((CharSequenceTranslator)StringEscapeUtils.ESCAPE_HTML4).append("<!doctype html>\n<html lang='en'>\n<head>\n<meta charset=utf-8>\n<title>X.509 Login</title>\n</head>\n<body>\n<p>Logged on as [").escape(principal.getName()).append("]</p>\n</body>\n</html>").toString());
                return;
            }
        }
        log.error("Received request to unknown sub-path [{}] of [/ext-login/org.clazzes.login.x509/].", (Object)pi);
        resp.sendError(404);
    }

    public String getServletInfo() {
        return X509HttpLoginService.class.getSimpleName();
    }
}

