/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigInteger;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.clazzes.login.external.ConfigurationService;
import org.clazzes.login.external.GlobalConfig;
import org.clazzes.login.external.IssuerConfig;
import org.clazzes.login.external.X509CertRef;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509HttpLoginService
implements HttpLoginService {
    private static final Logger log = LoggerFactory.getLogger(X509HttpLoginService.class);
    public static final String CTX_URL_PREFIX = "/ext-login/org.clazzes.login.x509/ctx/";
    private final ConfigurationService configurationService;

    public X509HttpLoginService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public static final BigInteger parseClientSerial(String serial) {
        return new BigInteger(serial.replace(":", ""), 16);
    }

    protected X509CertRef parseCertRef(HttpServletRequest request) {
        BigInteger serial;
        GlobalConfig gc = this.configurationService.getGlobalConfig();
        String subjectDn = request.getHeader(gc.getSubjectDnHeader());
        String issuerDn = request.getHeader(gc.getIssuerDnHeader());
        String serialString = request.getHeader(gc.getSerialHeader());
        if (subjectDn == null) {
            if (gc.isMainLoginMethod()) {
                log.error("Missing Subject DN in request to [{}]", (Object)RequestHelper.describeRequest((ServletRequest)request));
            }
            return null;
        }
        if (!gc.isMainLoginMethod()) {
            log.info("Found Subject DN in request to [{}]", (Object)RequestHelper.describeRequest((ServletRequest)request));
        }
        if (issuerDn == null) {
            log.error("Missing Issuer DN in request to [{}]", (Object)RequestHelper.describeRequest((ServletRequest)request));
            return null;
        }
        if (serialString == null) {
            log.error("Missing Serial in request to [{}]", (Object)RequestHelper.describeRequest((ServletRequest)request));
            return null;
        }
        try {
            serial = X509HttpLoginService.parseClientSerial(serialString);
        }
        catch (NumberFormatException e) {
            log.error("Malformatted serial number [{}] in request to [{}]", (Object)serialString, (Object)RequestHelper.describeRequest((ServletRequest)request));
            return null;
        }
        return new X509CertRef(subjectDn, issuerDn, serial);
    }

    public String getLoginUrl() {
        return "/ext-login/org.clazzes.login.x509/login";
    }

    public Principal checkLogin(HttpServletRequest request) {
        GlobalConfig gc = this.configurationService.getGlobalConfig();
        X509CertRef ref = this.parseCertRef(request);
        if (ref == null) {
            return null;
        }
        IssuerConfig issuerConfig = this.configurationService.getIssuerConfig(ref.getIssuerDn());
        if (issuerConfig == null) {
            if (gc.isMainLoginMethod()) {
                log.error("Request with certificate [{}] to [{}] refers to an unknown issuer DN.", (Object)ref, (Object)RequestHelper.describeRequest((ServletRequest)request));
            } else {
                log.info("Request with certificate [{}] to [{}] refers to an unknown issuer DN.", (Object)ref, (Object)RequestHelper.describeRequest((ServletRequest)request));
            }
            return null;
        }
        if (!issuerConfig.checkCertStatus(ref)) {
            return null;
        }
        log.info("Got request with certificate [{}] to [{}]", (Object)ref, (Object)RequestHelper.describeRequest((ServletRequest)request));
        try {
            return new X500Principal(ref.getSubjectDn());
        }
        catch (IllegalArgumentException e) {
            log.error("Request with certificate [{}] to [{}] contains a malformatted subject DN.", (Object)ref, (Object)RequestHelper.describeRequest((ServletRequest)request));
            if (log.isDebugEnabled()) {
                log.debug("Detailed IAE for malformatted subject DN", (Throwable)e);
            }
            return null;
        }
    }

    public List<? extends Principal> checkLoginGroups(HttpServletRequest request) {
        return null;
    }

    public Locale getLocale(HttpServletRequest request) {
        return request.getLocale();
    }

    public TimeZone getTimeZone(HttpServletRequest request) {
        return TimeZone.getDefault();
    }

    public boolean checkPermission(HttpServletRequest request, String context) {
        String ctx;
        Set<String> wl;
        if (context.equals(this.getLoginUrl())) {
            return true;
        }
        if (context.startsWith(CTX_URL_PREFIX) && (wl = this.configurationService.getWhiteList(ctx = context.substring(CTX_URL_PREFIX.length()))) != null) {
            String subjectDn = request.getHeader(this.configurationService.getGlobalConfig().getSubjectDnHeader());
            return wl.contains(subjectDn);
        }
        return false;
    }

    public void logout(HttpServletRequest request) {
        log.info("X.509 logout is not implemented.");
    }
}

