/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.clazzes.login.external.X509CertRef;
import org.clazzes.util.sched.ITimedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuerConfig
implements Runnable,
ITimedJob {
    private static final Logger log = LoggerFactory.getLogger(IssuerConfig.class);
    private final String crlDistributionPoint;
    private final String crlVerificationCertificate;
    private final Set<String> subjectDnBlacklist;
    private final long refreshCrlMinutes;
    private final long refreshCrlMinutesOnFailure;
    private Long nextCrlLoad;
    private X509CRL crl;

    public IssuerConfig(String crlDistributionPoint, String crlVerificationCertificate, Set<String> subjectDnBlacklist, long refreshCrlMinutes, long refreshCrlMinutesOnFailure) {
        this.crlDistributionPoint = crlDistributionPoint;
        this.crlVerificationCertificate = crlVerificationCertificate;
        this.subjectDnBlacklist = subjectDnBlacklist;
        this.refreshCrlMinutes = refreshCrlMinutes;
        this.refreshCrlMinutesOnFailure = refreshCrlMinutesOnFailure;
        this.nextCrlLoad = crlDistributionPoint == null ? null : Long.valueOf(System.currentTimeMillis() + 1000L);
    }

    public synchronized X509CRL getCrl() {
        return this.crl;
    }

    public synchronized void setCrl(X509CRL crl) {
        if (crl == null) {
            this.nextCrlLoad = System.currentTimeMillis() + this.refreshCrlMinutesOnFailure * 60000L;
        } else {
            long now = System.currentTimeMillis();
            long updateMillis = System.currentTimeMillis() + this.refreshCrlMinutes * 60000L;
            Date d = crl.getNextUpdate();
            if (d != null && d.getTime() < updateMillis) {
                if (d.getTime() > now) {
                    updateMillis = d.getTime();
                } else {
                    log.warn("Next update [{}] of CRL for [{}] is in the past, using failure refresh interval.", (Object)d, (Object)crl.getIssuerX500Principal());
                    updateMillis = System.currentTimeMillis() + this.refreshCrlMinutesOnFailure * 60000L;
                }
            }
            log.info("Next CRL refresh for [{}] is [{}].", (Object)crl.getIssuerX500Principal(), (Object)new Date(updateMillis));
            this.nextCrlLoad = updateMillis;
        }
        this.crl = crl;
    }

    public String getCrlDistributionPoint() {
        return this.crlDistributionPoint;
    }

    public Set<String> getSubjectDnBlacklist() {
        return this.subjectDnBlacklist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCertStatus(X509CertRef ref) {
        if (this.subjectDnBlacklist != null && this.subjectDnBlacklist.contains(ref.getSubjectDn())) {
            log.error("Certificate [{}] is blacklisted.", (Object)ref);
            return false;
        }
        X509CRLEntry entry = null;
        IssuerConfig issuerConfig = this;
        synchronized (issuerConfig) {
            if (this.crl == null) {
                if (this.crlDistributionPoint != null) {
                    log.error("Certificate [{}] is rejected, because the issuer CRL is not yet loaded.", (Object)ref);
                    return false;
                }
                return true;
            }
            entry = this.crl.getRevokedCertificate(ref.getSerial());
        }
        if (entry == null) {
            return true;
        }
        log.error("Certificate [{}] has been revoked at [{}] with reason [{}].", new Object[]{ref, entry.getRevocationDate(), entry.getRevocationReason()});
        return false;
    }

    public synchronized Long getNextExecutionDelay() {
        return this.nextCrlLoad == null ? null : Long.valueOf(this.nextCrlLoad - System.currentTimeMillis());
    }

    @Override
    public void run() {
        X509CRL verifiedCrl = null;
        try {
            X509CRL crl;
            log.info("Loading CRL from [{}]", (Object)this.crlDistributionPoint);
            URL url = new URL(this.crlDistributionPoint);
            URLConnection conn = url.openConnection();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (InputStream is = conn.getInputStream();){
                crl = (X509CRL)cf.generateCRL(is);
            }
            log.info("Successfully loaded CRL from [{}]", (Object)this.crlDistributionPoint);
            if (this.crlVerificationCertificate == null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                block12: for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                    for (X509Certificate cert : x509TrustManager.getAcceptedIssuers()) {
                        if (!cert.getSubjectX500Principal().equals(crl.getIssuerX500Principal())) continue;
                        log.info("Verifying CRL from [{}] with Certificate [{}].", (Object)this.crlDistributionPoint, (Object)cert.getSubjectX500Principal());
                        cert.checkValidity();
                        crl.verify(cert.getPublicKey());
                        log.info("Successfully verified CRL from [{}]", (Object)this.crlDistributionPoint);
                        verifiedCrl = crl;
                        continue block12;
                    }
                }
            } else {
                X509Certificate cert;
                try (FileInputStream is = new FileInputStream(this.crlVerificationCertificate);){
                    cert = (X509Certificate)cf.generateCertificate(is);
                }
                log.info("Verifying CRL from [{}] with Certificate [{}] from [{}].", new Object[]{this.crlDistributionPoint, cert.getSubjectX500Principal(), this.crlVerificationCertificate});
                cert.checkValidity();
                crl.verify(cert.getPublicKey());
                log.info("Successfully verified CRL from [{}]", (Object)this.crlDistributionPoint);
                verifiedCrl = crl;
            }
            if (verifiedCrl == null) {
                log.error("Cannot find a signing certificate for CRL from [{}].", (Object)this.crlDistributionPoint);
            }
        }
        catch (Exception e) {
            log.error("Error loading CRL from URL [" + this.crlDistributionPoint + "]", (Throwable)e);
        }
        this.setCrl(verifiedCrl);
    }
}

