/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import jakarta.servlet.Servlet;
import java.util.function.Consumer;
import org.clazzes.login.external.ConfigurationService;
import org.clazzes.login.external.X509HttpLoginService;
import org.clazzes.login.external.X509LoginServlet;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.http.sec.HttpLoginService;

public class ExternalLoginComponent
implements Component {
    public static final String CONFIG_PID = "org.clazzes.login.external";
    public static final String SERVICE_KEY = "org.clazzes.login.x509";
    public static final String SERVLET_PATH = "/ext-login/org.clazzes.login.x509/*";

    public void start(ServiceContext context) throws Exception {
        ConfigurationEngine ce = (ConfigurationEngine)context.getService(ConfigurationEngine.class).get();
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = (ComponentManager)context.getService(ComponentManager.class).get();
        ConfigurationService cs = new ConfigurationService();
        X509HttpLoginService xhls = new X509HttpLoginService(cs);
        registry.addService(SERVICE_KEY, HttpLoginService.class, (Object)xhls);
        X509LoginServlet x509Servlet = new X509LoginServlet(xhls);
        registry.addService(SERVLET_PATH, Servlet.class, (Object)x509Servlet);
        ce.listen(CONFIG_PID, (Consumer)cs);
        componentManager.commit();
    }

    public void stop(ServiceContext context) throws Exception {
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        registry.removeService(SERVLET_PATH, Servlet.class);
        registry.removeService(SERVICE_KEY, HttpLoginService.class);
    }
}

