/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Consumer;
import org.clazzes.login.external.GlobalConfig;
import org.clazzes.login.external.IssuerConfig;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements Consumer<ConfigWrapper> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private static final long DEFAULT_REFRESH_CRL_MINUTES = 1440L;
    private static final long DEFAULT_REFRESH_CRL_MINUTES_ON_FAILURE = 5L;
    private final Map<String, IssuerConfig> issuers = new HashMap<String, IssuerConfig>();
    private final Map<String, Set<String>> contexts = new HashMap<String, Set<String>>();
    private IOneTimeScheduler oneTimeScheduler;
    private final List<UUID> jobIds = new ArrayList<UUID>();
    private GlobalConfig globalConfig = GlobalConfig.ofDefault();

    private void stopJobs() {
        if (this.jobIds != null) {
            for (UUID jobId : this.jobIds) {
                log.info("Cancelling CRL update job with ID [{}].", (Object)jobId);
                this.oneTimeScheduler.cancelJob(jobId, true);
            }
        }
    }

    public synchronized void destroy() {
        this.issuers.clear();
        this.contexts.clear();
        this.stopJobs();
    }

    @Override
    public synchronized void accept(ConfigWrapper config) {
        this.issuers.clear();
        this.contexts.clear();
        this.stopJobs();
        this.jobIds.clear();
        if (config != null) {
            this.globalConfig = GlobalConfig.ofConfig(config);
            long refreshCrlMinutes = config.getLong("refreshCrlMinutes", 1440L);
            long refreshCrlMinutesOnFailure = config.getLong("refreshCrlMinutesOnFailure", 5L);
            log.info("Using refreshCrlMinutes [{}].", (Object)refreshCrlMinutes);
            log.info("Using refreshCrlMinutesOnFailure [{}].", (Object)refreshCrlMinutesOnFailure);
            ConfigWrapper wlConfig = config.getSubTree("whitelist");
            ConfigWrapper blConfig = config.getSubTree("blacklist");
            ConfigWrapper issConfig = config.getSubTree("issuer");
            HashMap blacklists = new HashMap();
            if (wlConfig != null) {
                for (String ctxt : wlConfig.keySet()) {
                    ConfigWrapper wlDns;
                    Set<String> whitelist = this.contexts.get(ctxt);
                    if (whitelist == null) {
                        whitelist = new HashSet<String>();
                        this.contexts.put(ctxt, whitelist);
                    }
                    if ((wlDns = wlConfig.getSubTree(ctxt)) == null) continue;
                    for (String key : wlDns.keySet()) {
                        String wdn = wlDns.getMandatoryString(key);
                        log.info("Adding [{}] to whitelist for context [{}]", (Object)wdn, (Object)ctxt);
                        whitelist.add(wdn);
                    }
                }
            }
            if (blConfig != null) {
                for (String label : blConfig.keySet()) {
                    ConfigWrapper blDns;
                    HashSet<String> blacklist = (HashSet<String>)blacklists.get(label);
                    if (blacklist == null) {
                        blacklist = new HashSet<String>();
                        blacklists.put(label, blacklist);
                    }
                    if ((blDns = blConfig.getSubTree(label)) == null) continue;
                    for (String key : blDns.keySet()) {
                        String bdn = blDns.getMandatoryString(key);
                        log.info("Adding [{}] to blacklist for issuer [{}]", (Object)bdn, (Object)label);
                        blacklist.add(bdn);
                    }
                }
            }
            if (issConfig != null) {
                for (String label : issConfig.keySet()) {
                    ConfigWrapper iCfg = issConfig.getSubTree(label);
                    Set<String> blacklist = (Set<String>)blacklists.get(label);
                    if (blacklist == null) {
                        blacklist = Collections.emptySet();
                    }
                    String dn = iCfg.getMandatoryString("dn");
                    log.info("Setting DN for issuer [{}] to [{}].", (Object)label, (Object)dn);
                    String crlDistributionPoint = iCfg.getString("crlDistributionPoint");
                    String crlVerificationCertificate = iCfg.getString("crlVerificationCertificate");
                    this.issuers.put(dn, new IssuerConfig(crlDistributionPoint, crlVerificationCertificate, blacklist, refreshCrlMinutes, refreshCrlMinutesOnFailure));
                }
            }
        }
        for (Map.Entry<String, IssuerConfig> e : this.issuers.entrySet()) {
            if (e.getValue().getCrlDistributionPoint() == null) continue;
            UUID jobId = this.oneTimeScheduler.scheduleJob((Runnable)e.getValue());
            log.info("Started CRL background job for issuer [{}] with job ID [{}]", (Object)e.getKey(), (Object)jobId);
            this.jobIds.add(jobId);
        }
    }

    public synchronized List<String> getIssuerDns() {
        Vector<String> domains = new Vector<String>(this.issuers.size());
        domains.addAll(this.issuers.keySet());
        return domains;
    }

    public synchronized IssuerConfig getIssuerConfig(String issuerDn) {
        return this.issuers.get(issuerDn);
    }

    public synchronized Set<String> getWhiteList(String context) {
        return this.contexts.get(context);
    }

    public synchronized GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }
}

