package org.clazzes.login.external;

import org.clazzes.svc.api.ConfigWrapper;

public class GlobalConfig {

    public static final String DEFAULT_SUBJECT_DN_HEADER ="SSL_CLIENT_S_DN";
    public static final String DEFAULT_ISSUER_DN_HEADER ="SSL_CLIENT_I_DN";
    public static final String DEFAULT_SERIAL_HEADER ="SSL_CLIENT_M_SERIAL";
    public static final boolean DEFAULT_MAIN_LOGIN_METHOD = true;

    private final String subjectDnHeader;
    private final String issuerDnHeader;
    private final String serialHeader;
    private final boolean mainLoginMethod;

    public GlobalConfig(String subjectDnHeader, String issuerDnHeader, String serialHeader, boolean mainLoginMethod) {
        this.subjectDnHeader = subjectDnHeader;
        this.issuerDnHeader = issuerDnHeader;
        this.serialHeader = serialHeader;
        this.mainLoginMethod = mainLoginMethod;
    }

    public static GlobalConfig ofDefault() {
        return new GlobalConfig(DEFAULT_SUBJECT_DN_HEADER,
                                DEFAULT_ISSUER_DN_HEADER,
                                DEFAULT_SERIAL_HEADER,
                                DEFAULT_MAIN_LOGIN_METHOD);
    }

    public static GlobalConfig ofConfig(ConfigWrapper config) {

        return new GlobalConfig(
            config.getString("subjectDnHeader",DEFAULT_ISSUER_DN_HEADER),
            config.getString("issuerDnHeader",DEFAULT_ISSUER_DN_HEADER),
            config.getString("serialHeader",DEFAULT_SERIAL_HEADER),
            config.getBoolean("isMainLoginMethod",DEFAULT_MAIN_LOGIN_METHOD));
    }

    public String getSubjectDnHeader() {
        return this.subjectDnHeader;
    }

    public String getIssuerDnHeader() {
        return this.issuerDnHeader;
    }

    public String getSerialHeader() {
        return this.serialHeader;
    }

    public boolean isMainLoginMethod() {
        return this.mainLoginMethod;
    }

    @Override
    public String toString() {
        return "GlobalConfig [subjectDnHeader=" + this.subjectDnHeader +
                ", issuerDnHeader=" + this.issuerDnHeader +
                ", serialHeader=" + this.serialHeader +
                ", mainLoginMethod=" + this.mainLoginMethod + "]";
    }

}
