package org.clazzes.login.external;

import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.sec.DomainPasswordLoginService;

import jakarta.servlet.Servlet;

public class ExternalLoginComponent implements Component {

    public static final String CONFIG_PID = "org.clazzes.login.external";
    public static final String SERVICE_KEY = "org.clazzes.login.x509";
    public static final String SERVLET_PATH = "/ext-login/org.clazzes.login.x509/*";

    @Override
    public void start(ServiceContext context) throws Exception {

        ConfigurationEngine ce = context.getService(ConfigurationEngine.class).get();
        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = context.getService(ComponentManager.class).get();

        ConfigurationService cs = new ConfigurationService();

        X509HttpLoginService xhls = new X509HttpLoginService(cs);

        registry.addService(SERVICE_KEY,HttpLoginService.class,xhls);

        X509LoginServlet x509Servlet = new X509LoginServlet(xhls);

        registry.addService(SERVLET_PATH,Servlet.class,x509Servlet);

        ce.listen(CONFIG_PID,cs);

        // commit here, to be up even without a configured domain.
        componentManager.commit();
    }

    @Override
    public void stop(ServiceContext context) throws Exception {

        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();

        registry.removeService(SERVLET_PATH,Servlet.class);
        registry.removeService(SERVICE_KEY,HttpLoginService.class);
    }

}
