/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.external;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.clazzes.login.external.IssuerConfig;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements ManagedService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private static final long DEFAULT_REFRESH_CRL_MINUTES = 1440L;
    private static final long DEFAULT_REFRESH_CRL_MINUTES_ON_FAILURE = 5L;
    private final Map<String, IssuerConfig> issuers = new HashMap<String, IssuerConfig>();
    private final Map<String, Set<String>> contexts = new HashMap<String, Set<String>>();
    private IOneTimeScheduler oneTimeScheduler;
    private final List<UUID> jobIds = new ArrayList<UUID>();

    private void stopJobs() {
        if (this.jobIds != null) {
            for (UUID jobId : this.jobIds) {
                log.info("Cancelling CRL update job with ID [{}].", (Object)jobId);
                this.oneTimeScheduler.cancelJob(jobId, true);
            }
        }
    }

    public synchronized void destroy() {
        this.issuers.clear();
        this.contexts.clear();
        this.stopJobs();
    }

    public synchronized void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.issuers.clear();
        this.contexts.clear();
        this.stopJobs();
        this.jobIds.clear();
        if (properties != null) {
            long refreshCrlMinutes = 1440L;
            Object refreshCrlMinutes_o = properties.get("refreshCrlMinutes");
            if (refreshCrlMinutes_o != null) {
                refreshCrlMinutes = Long.parseLong(refreshCrlMinutes_o.toString());
            }
            long refreshCrlMinutesOnFailure = 5L;
            Object refreshCrlMinutesOnFailure_o = properties.get("refreshCrlMinutesOnFailure");
            if (refreshCrlMinutesOnFailure_o != null) {
                refreshCrlMinutesOnFailure = Long.parseLong(refreshCrlMinutesOnFailure_o.toString());
            }
            log.info("Using refreshCrlMinutes [{}].", (Object)refreshCrlMinutes);
            log.info("Using refreshCrlMinutesOnFailure [{}].", (Object)refreshCrlMinutesOnFailure);
            Enumeration<String> keys = properties.keys();
            HashMap<String, Set<Object>> blacklists = new HashMap<String, Set<Object>>();
            while (keys.hasMoreElements()) {
                Set<String> blacklist;
                int idx;
                String key = keys.nextElement();
                if (key.startsWith("whitelist.") && (idx = key.lastIndexOf(46)) > 10) {
                    String ctxt = key.substring(10, idx);
                    Set<String> whitelist = this.contexts.get(ctxt);
                    if (whitelist == null) {
                        whitelist = new HashSet<String>();
                        this.contexts.put(ctxt, whitelist);
                    }
                    String wdn = properties.get(key).toString();
                    log.info("Adding [{}] to whitelist for context [{}]", (Object)wdn, (Object)ctxt);
                    whitelist.add(wdn);
                }
                if (key.startsWith("blacklist.") && (idx = key.lastIndexOf(46)) > 10) {
                    String label = key.substring(10, idx);
                    blacklist = (HashSet)blacklists.get(label);
                    if (blacklist == null) {
                        blacklist = new HashSet();
                        blacklists.put(label, blacklist);
                    }
                    String bdn = properties.get(key).toString();
                    log.info("Adding [{}] to blacklist for issuer [{}]", (Object)bdn, (Object)label);
                    blacklist.add(bdn);
                }
                if (!key.startsWith("issuer.") || !key.endsWith(".dn")) continue;
                String label = key.substring(7, key.length() - 3);
                String dn = properties.get(key).toString();
                blacklist = (Set)blacklists.get(label);
                if (blacklist == null) {
                    blacklist = new HashSet();
                    blacklists.put(label, blacklist);
                }
                log.info("Setting DN for issuer [{}] to [{}].", (Object)label, (Object)dn);
                Object crlDistributionPoint_o = properties.get("issuer." + label + ".crlDistributionPoint");
                String crlDistributionPoint = null;
                if (crlDistributionPoint_o != null) {
                    log.info("Setting CRL distribution point for issuer [{}] to [{}].", (Object)label, crlDistributionPoint_o);
                    crlDistributionPoint = crlDistributionPoint_o.toString();
                }
                Object crlVerificationCertificate_o = properties.get("issuer." + label + ".crlVerificationCertificate");
                String crlVerificationCertificate = null;
                if (crlVerificationCertificate_o != null) {
                    log.info("Setting CRL verification certificate for issuer [{}] to [{}].", (Object)label, crlVerificationCertificate_o);
                    crlVerificationCertificate = crlVerificationCertificate_o.toString();
                }
                this.issuers.put(dn, new IssuerConfig(crlDistributionPoint, crlVerificationCertificate, blacklist, refreshCrlMinutes, refreshCrlMinutesOnFailure));
            }
        }
        for (Map.Entry<String, IssuerConfig> e : this.issuers.entrySet()) {
            if (e.getValue().getCrlDistributionPoint() == null) continue;
            UUID jobId = this.oneTimeScheduler.scheduleJob((Runnable)e.getValue());
            log.info("Started CRL background job for issuer [{}] with job ID [{}]", (Object)e.getKey(), (Object)jobId);
            this.jobIds.add(jobId);
        }
    }

    public synchronized List<String> getIssuerDns() {
        Vector<String> domains = new Vector<String>(this.issuers.size());
        domains.addAll(this.issuers.keySet());
        return domains;
    }

    public synchronized IssuerConfig getIssuerConfig(String issuerDn) {
        return this.issuers.get(issuerDn);
    }

    public synchronized Set<String> getWhiteList(String context) {
        return this.contexts.get(context);
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }
}

