/**
 * $Id$
 *
 * Enterprise Service Management
 * (c) 2019 ITEG IT-Engineers GmbH https://www.iteg.at
 */
package org.clazzes.login.external;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

/**
 * A reference to an X.509 certificate as reported by a reverse proxy.
 */
public class X509CertRef implements Serializable {

    private static final long serialVersionUID = -1553391055013672240L;

    private final String subjectDn;
    private final String issuerDn;
    private final BigInteger serial;
    
    public X509CertRef(String subjectDn, String issuerDn, BigInteger serial) {
        super();
        this.subjectDn = subjectDn;
        this.issuerDn = issuerDn;
        this.serial = serial;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.issuerDn,this.serial,this.subjectDn);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        X509CertRef other = (X509CertRef) obj;
        return Objects.equals(this.issuerDn, other.issuerDn) &&
                Objects.equals(this.serial, other.serial) &&
                Objects.equals(this.subjectDn, other.subjectDn);
    }

    @Override
    public String toString() {
        return "X509CertRef [subjectDn=" + this.subjectDn + ", issuerDn=" + this.issuerDn + ", serial=" + this.serial + "]";
    }
    
    
}
