/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.broker;

import java.util.List;
import org.clazzes.login.broker.ConfigurationService;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;

public class BrokerDomainPasswordLoginService
implements DomainPasswordLoginService {
    private ConfigurationService configurationService;

    public DomainPrincipal tryLogin(String domain, String username, String password) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        return loginService.tryLogin(domain, username, password);
    }

    public String getDefaultDomain() {
        return this.configurationService.getDefaultDomain();
    }

    public void changePassword(String domain, String username, String oldPassword, String newPassword) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        loginService.changePassword(domain, username, oldPassword, newPassword);
    }

    public void deactivateUser(String domain, String username, String reason) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        loginService.deactivateUser(domain, username, reason);
    }

    public List<DomainGroup> getGroups(String domain, String userName) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        return loginService.getGroups(domain, userName);
    }

    public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        return loginService.getGroupMembers(domain, groupName);
    }

    public int getSupportedFeatures(String domain) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        return loginService.getSupportedFeatures(domain);
    }

    public DomainPrincipal searchUser(String domain, String username) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        return loginService.searchUser(domain, username);
    }

    public void sendPassword(String domain, String username) {
        DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);
        if (loginService == null) {
            throw new SecurityException("Invalid domain [" + domain + "] specified.");
        }
        loginService.sendPassword(domain, username);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public List<String> getDomains() {
        return this.configurationService.getDomains();
    }
}

