/***********************************************************
 * $Id$
 * 
 * Multi backend broker variant of clazzes.org Login Service API
 * 
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.broker;

import java.util.List;

import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;

public class BrokerDomainPasswordLoginService implements
    DomainPasswordLoginService {

  //private static final Logger log = LoggerFactory.getLogger(BrokerDomainPasswordLoginService.class);
  
  private ConfigurationService configurationService;

  
  @Override
  public DomainPrincipal tryLogin(String domain, String username, String password) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null) {
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    }
    
    return loginService.tryLogin(domain, username, password);
  }

  
  @Override
  public String getDefaultDomain() {
    return this.configurationService.getDefaultDomain();
  }


  @Override
  public void changePassword(String domain, String username, String oldPassword, String newPassword) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    loginService.changePassword(domain, username, oldPassword, newPassword);
  }

  
  @Override
  public void deactivateUser(String domain, String username, String reason) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    loginService.deactivateUser(domain, username, reason);
  }

  
  @Override
  public List<DomainGroup> getGroups(String domain, String userName) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    return loginService.getGroups(domain, userName);
  }

  
  @Override
  public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    return loginService.getGroupMembers(domain, groupName);
  }

  
  @Override
  public int getSupportedFeatures(String domain) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    return loginService.getSupportedFeatures(domain);
  }

  
  @Override
  public DomainPrincipal searchUser(String domain, String username) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    return loginService.searchUser(domain, username);
  }

  
  @Override
  public void sendPassword(String domain, String username) {
    
    DomainPasswordLoginService loginService = this.configurationService.getLoginService(domain);

    if (loginService == null)
      throw new SecurityException("Invalid domain ["+domain+"] specified.");
    
    loginService.sendPassword(domain, username);
  }


  public ConfigurationService getConfigurationService() {
    return configurationService;
  }


  public void setConfigurationService(ConfigurationService configurationService) {
    this.configurationService = configurationService;
  }


  @Override
  public List<String> getDomains() {
    return this.configurationService.getDomains();
  }

}
