/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.broker;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.clazzes.util.osgi.ServiceMapListener;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements ServiceMapListener,
ManagedService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private String defaultDomain = null;
    private Map<String, DomainPasswordLoginService> loginServicesByDomain = new HashMap<String, DomainPasswordLoginService>();
    private Map<String, DomainPasswordLoginService> loginServicesByMechanism = new HashMap<String, DomainPasswordLoginService>();

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        Object s;
        Object object = s = properties == null ? null : (Object)properties.get("defaultDomain");
        if (s != null) {
            this.defaultDomain = s.toString();
            if (log.isDebugEnabled()) {
                log.debug("Setting default domain to [{}].", (Object)this.defaultDomain);
            }
        } else {
            this.defaultDomain = null;
            if (log.isDebugEnabled()) {
                log.debug("Setting default domain to default [{}].", (Object)this.defaultDomain);
            }
        }
    }

    public synchronized String getDefaultDomain() {
        return this.defaultDomain;
    }

    public synchronized void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public synchronized void serviceBound(String mechanism, Object service) {
        if ("org.clazzes.login.broker".equals(mechanism)) {
            log.info("Not registering myself, with mechanism [{}]", (Object)mechanism);
            return;
        }
        DomainPasswordLoginService domainPasswordLoginService = (DomainPasswordLoginService)service;
        log.info("Remembering DomainPasswordLoginService for mechanism [{}]", (Object)mechanism);
        this.loginServicesByMechanism.put(mechanism, domainPasswordLoginService);
        HashSet<String> dplsDomains = new HashSet<String>();
        String dplsDefaultDomain = domainPasswordLoginService.getDefaultDomain();
        if (dplsDefaultDomain != null && dplsDefaultDomain.length() > 0) {
            dplsDomains.add(dplsDefaultDomain);
        } else {
            log.warn("DomainPasswordLoginService with mechanism [{}] does not have a default domain.", (Object)mechanism);
        }
        List domains = domainPasswordLoginService.getDomains();
        if (domains != null) {
            dplsDomains.addAll(domains);
        }
        if (dplsDomains.size() == 0) {
            log.warn("DomainPasswordLoginService with mechanism [{}] does not cover any domain. Ignoring it.", (Object)mechanism);
            return;
        }
        for (String dplsDomain : dplsDomains) {
            DomainPasswordLoginService knownDpls = this.loginServicesByDomain.get(dplsDomain);
            if (knownDpls == null) {
                log.info("Remebering DomainPasswordLoginService for mechanism [{}] to cover domain [{}]", (Object)mechanism, (Object)dplsDomain);
                this.loginServicesByDomain.put(dplsDomain, domainPasswordLoginService);
                continue;
            }
            log.error("A DomainPasswordLoginService for mechanism [{}] covering domain [{}] is already present, ignoring new one.", (Object)mechanism, (Object)dplsDomain);
        }
    }

    public synchronized void serviceUnbound(String mechanism, Object service) {
        if ("org.clazzes.login.broker".equals(mechanism)) {
            log.info("Not unregistering myself, with mechanism [{}]", (Object)mechanism);
            return;
        }
        DomainPasswordLoginService domainPasswordLoginService = (DomainPasswordLoginService)service;
        log.info("Forgetting about DomainPasswordLoginService for mechanism [{}]", (Object)mechanism);
        DomainPasswordLoginService removedDpls = this.loginServicesByMechanism.remove(mechanism);
        if (removedDpls == null) {
            log.info("Had no knowledge about DomainPasswordLoginService for mechanism [{}]", (Object)mechanism);
        }
        HashSet<String> dplsDomains = new HashSet<String>();
        String dplsDefaultDomain = domainPasswordLoginService.getDefaultDomain();
        if (dplsDefaultDomain != null && dplsDefaultDomain.length() > 0) {
            dplsDomains.add(dplsDefaultDomain);
        } else {
            log.warn("DomainPasswordLoginService with mechanism [{}] does not have a default domain.", (Object)mechanism);
        }
        List domains = domainPasswordLoginService.getDomains();
        if (domains != null) {
            dplsDomains.addAll(domains);
        }
        if (dplsDomains.size() == 0) {
            log.warn("DomainPasswordLoginService with mechanism [{}] does not cover any domain. Ignoring it.", (Object)mechanism);
            return;
        }
        for (String dplsDomain : dplsDomains) {
            log.info("Forgetting about DomainPasswordLoginService for mechanism [{}] covering domain [{}]", (Object)mechanism, (Object)dplsDomain);
            removedDpls = this.loginServicesByDomain.remove(dplsDomain);
            if (removedDpls != null) continue;
            log.info("Had no knowledge about DomainPasswordLoginService for mechanism [{}] covering domain [{}]", (Object)mechanism, (Object)dplsDomain);
        }
    }

    public synchronized DomainPasswordLoginService getLoginService(String domain) {
        DomainPasswordLoginService domainPasswordLoginService = this.loginServicesByDomain.get(domain);
        if (domainPasswordLoginService == null) {
            log.info("Request for DomainPasswordLoginService for domain [{}] cannot be covered from cache, searching all known services by mechanism");
            this.rescanLoginServices();
            domainPasswordLoginService = this.loginServicesByDomain.get(domain);
        }
        if (domainPasswordLoginService == null) {
            log.warn("Request for DomainPasswordLoginService for domain [{}] cannot be satisfied.");
        }
        return domainPasswordLoginService;
    }

    public synchronized void rescanLoginServices() {
        for (String mechanism : this.loginServicesByMechanism.keySet()) {
            log.info("Re-Scanning DomainPasswordLoginService for mechanism [{}]", (Object)mechanism);
            DomainPasswordLoginService loginService = this.loginServicesByMechanism.get(mechanism);
            HashSet<String> dplsDomains = new HashSet<String>();
            String dplsDefaultDomain = loginService.getDefaultDomain();
            if (dplsDefaultDomain != null && dplsDefaultDomain.length() > 0) {
                dplsDomains.add(dplsDefaultDomain);
            } else {
                log.warn("DomainPasswordLoginService for mechanism [{}] has no default domain", (Object)mechanism);
            }
            List domains = loginService.getDomains();
            if (domains != null) {
                dplsDomains.addAll(loginService.getDomains());
            }
            if (dplsDomains.size() == 0) {
                log.warn("DomainPasswordLoginService for mechanism [{}] does not cover any domains, skipping it...", (Object)mechanism);
                continue;
            }
            for (String dplsDomain : dplsDomains) {
                DomainPasswordLoginService knownDpls = this.loginServicesByDomain.get(dplsDomain);
                if (knownDpls == null) {
                    log.info("Found out about known DomainPasswordLoginService for mechanism [{}] to cover the additional domain [{}]", (Object)mechanism, (Object)dplsDomain);
                    this.loginServicesByDomain.put(dplsDomain, loginService);
                    continue;
                }
                log.debug("I already known about DomainPasswordLoginService for mechanism [{}] to cover the domain [{}]", (Object)mechanism, (Object)dplsDomain);
            }
        }
    }

    public List<String> getDomains() {
        HashSet<String> dplsDomains = new HashSet<String>();
        for (String mechanism : this.loginServicesByMechanism.keySet()) {
            DomainPasswordLoginService loginService = this.loginServicesByMechanism.get(mechanism);
            String dplsDefaultDomain = loginService.getDefaultDomain();
            if (dplsDefaultDomain != null && dplsDefaultDomain.length() > 0) {
                dplsDomains.add(dplsDefaultDomain);
            }
            dplsDomains.addAll(loginService.getDomains());
        }
        Vector<String> domains = new Vector<String>(dplsDomains.size());
        domains.addAll(dplsDomains);
        return domains;
    }
}

