/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.authorization.context;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.clazzes.login.authorization.context.SecurityAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextData {
    private static final Logger log = LoggerFactory.getLogger(SecurityContextData.class);
    public static final String SECURITY_CONTEXT_HOSTNAME = "annotated.clazzes.org";
    private final SecurityAction action;
    private final String context;
    private static final URLStreamHandler OwnHandler = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL url) {
            return null;
        }
    };

    public SecurityContextData(SecurityAction action, String context) {
        this.action = action;
        this.context = context;
    }

    public SecurityAction getAction() {
        return this.action;
    }

    public String getPath() {
        if (this.context == null) {
            return "";
        }
        return this.context;
    }

    public String toExternalForm() {
        try {
            Object path = this.getPath();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            String file = path;
            URL uu = new URL(this.getAction().toString(), SECURITY_CONTEXT_HOSTNAME, -1, file, OwnHandler);
            return uu.toExternalForm();
        }
        catch (MalformedURLException e) {
            log.error("Malformed Context", (Throwable)e);
            return null;
        }
    }

    public static SecurityContextData fromExternalForm(String ext) {
        try {
            URL uu = new URL(null, ext, OwnHandler);
            SecurityAction securityAction = SecurityAction.valueOfIgnoreCase(uu.getProtocol());
            return new SecurityContextData(securityAction, uu.getPath());
        }
        catch (MalformedURLException e) {
            log.error("Malformed Context", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        String result = this.toExternalForm();
        if (result != null) {
            return result;
        }
        return "MALFORMED: ActionAndContext{action=" + String.valueOf((Object)this.action) + ", context='" + this.context + "'}";
    }
}

