/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.authorization.context;

import java.util.Arrays;
import java.util.Optional;

public enum SecurityAction {
    MISSING,
    NEVER_ALLOW,
    ADMIN,
    WRITE,
    READ,
    ALWAYS_ALLOW_NO_SECURITY;


    public static SecurityAction valueOfIgnoreCase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("SecurityAction was not set.");
        }
        Optional<SecurityAction> resultOpt = Arrays.stream(SecurityAction.values()).filter(v -> v.toString().equalsIgnoreCase(name)).findAny();
        if (!resultOpt.isPresent()) {
            throw new IllegalArgumentException("SecurityAction " + name + " was not found.");
        }
        return resultOpt.get();
    }

    public String toString() {
        return super.toString().replace("_", "-");
    }
}

