package org.clazzes.login.authorization.context;

import java.util.Arrays;
import java.util.Optional;

/**
 * The valid actions a security context may have.
 * In MDA, there are three dimensions: action, context-string, measure-point-ids.
 */
public enum SecurityAction {
    MISSING,
    NEVER_ALLOW,
    ADMIN,
    WRITE,
    READ,
    ALWAYS_ALLOW_NO_SECURITY;

    /**
     * Parse the enum and search ignoring the case.
     */
    public static SecurityAction valueOfIgnoreCase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("SecurityAction was not set.");
        }
        Optional<SecurityAction> resultOpt = Arrays.stream(values())
                .filter(v -> v.toString().equalsIgnoreCase(name))
                .findAny();
        if (!resultOpt.isPresent()) {
            throw new IllegalArgumentException("SecurityAction " + name + " was not found.");
        }
        return resultOpt.get();
    }

    /**
     * We need a valid protocol format (underlines are wrong)
     */
    public String toString() {
        return super.toString().replace("_", "-");
    }
}
