package org.clazzes.login.authorization.context;

import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.util.http.aop.HttpContextProvider;

import org.clazzes.login.authorization.annotations.*;

public class AnnotatedHttpContextProvider implements HttpContextProvider {
	
    @Override
    public String getContextUrl(MethodInvocation invocation) {

        SecurityContextData securityContextData = getContextObject(invocation);
        return securityContextData.toExternalForm();
    }

    private SecurityContextData getContextObject(MethodInvocation invocation) {
        NeverAllowed neverAllowed = invocation.getMethod().getAnnotation(NeverAllowed.class);
        if (neverAllowed != null) {
            return new SecurityContextData(SecurityAction.NEVER_ALLOW, null);
        }

        AdminSecurity adminSecurity = invocation.getMethod().getAnnotation(AdminSecurity.class);
        if (adminSecurity != null) {
            String context = adminSecurity.value();
            return new SecurityContextData(SecurityAction.ADMIN, context);
        }

        WriteSecurity writeSecurity = invocation.getMethod().getAnnotation(WriteSecurity.class);
        if (writeSecurity != null) {
            String context = writeSecurity.value();
            return new SecurityContextData(SecurityAction.WRITE, context);
        }

        ReadSecurity readSecurity = invocation.getMethod().getAnnotation(ReadSecurity.class);
        if (readSecurity != null) {
            String context = readSecurity.value();
            return new SecurityContextData(SecurityAction.READ, context);
        }

        NoSecurityNecessary unnecessarySecurity = invocation.getMethod().getAnnotation(NoSecurityNecessary.class);
        if (unnecessarySecurity != null) {
            return new SecurityContextData(SecurityAction.ALWAYS_ALLOW_NO_SECURITY, null);
        }

        PubliclyAccessible publiclyAccessible = invocation.getMethod().getAnnotation(PubliclyAccessible.class);
        if (publiclyAccessible != null) {
            return new SecurityContextData(SecurityAction.ALWAYS_ALLOW_NO_SECURITY, null);
        }

        // probably we might look for the annotations on class level as well!?

        return new SecurityContextData(SecurityAction.MISSING, null);
    }
}
