package org.clazzes.login.authorization.annotations;

import java.lang.annotation.*;

/**
 * If the logged-in user does have the user-right (WRITE, value), allow.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface WriteSecurity {
    String why() default ""; // ignored description
    /** @see "UserRightConstants"
     */
    String value(); // context-name
}

