package org.clazzes.login.authorization.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * No LOGIN is needed, so this method is PUBLIC accessible.
 * IMPORTANT: Do think about DoS attacks (how much does it cost to result).
 *
 * Always provide the reason as NO login is needed!
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface PubliclyAccessible {
    String why(); // description
}
