package org.clazzes.login.authorization.annotations;

import java.lang.annotation.*;

/**
 * If the logged-in user does have the user-right (ADMIN, value), allow.
 *
 * Usage: some special admin privilege is necessary like it is dangerous to call with wrong arguments or results into
 * data which consists of several clients.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface AdminSecurity {
    String why() default ""; // ignored description
    /** @see "UserRightConstants"
     */
    String value(); // context-name
}
