/***********************************************************
 *
 * ASN.1 Tools of the clazzes.org project
 * https://www.clazzes.org
 *
 * Created: 24.07.2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

 package org.clazzes.login.asn1.tools;

import java.io.IOException;

/**
 * An ASN.1 specific exception arising from serialization or deserialization
 * of an ASN.1 structure.
 */
public class ASN1Exception extends IOException {

    public ASN1Exception() {
        super();
    }

    public ASN1Exception(String msg) {
        super(msg);
    }

    public ASN1Exception(Throwable cause) {
        super(cause);
    }

    public ASN1Exception(String msg, Throwable cause) {
        super(msg,cause);
    }

}
