/***********************************************************
 *
 * ASN.1 Tools of the clazzes.org project
 * https://www.clazzes.org
 *
 * Created: 24.07.2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.asn1.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * A filter input stream, which explicitly does not support mark operations.
 * and skips by reading through the content.
 *
 * This is a base class for implementing other special purpose input streams.
 */
public class NoMarkInputStream extends FilterInputStream {

    protected NoMarkInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long n) throws IOException {

        int sz = 16384;

        if (n < sz) {
            sz = (int)n;
        }

        byte[] buf = new byte[sz];

        int ret = this.read(buf);

        return ret > 0 ? ret : 0L;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}