/***********************************************************
 *
 * ASN.1 Tools of the clazzes.org project
 * https://www.clazzes.org
 *
 * Created: 24.07.2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.asn1.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.ietf.jgss.Oid;

/**
 * <p>Mark an abstract function returning an integer or an Oid
 * to discriminate between specializations of a polymorphic type.</p>
 *
 * <p>Either an oid or an integer value must be defined.</p>
 *
 * <p>This annotation has to specifiec multiple times for a given
 * abstract discriminator method in order to specify the individual
 * implementations associated with each possible return value.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Repeatable(ASN1TypeSwitch.class)
public @interface ASN1TypeCase {

    /**
     * The OID discriminator value return by the method,
     * if the method return value is {@link Oid}.
     */
    String oid() default "";

    /**
     * The integer discriminator value return by the method,
     * if the method return value is an integer.
     */

    int    value() default Integer.MIN_VALUE;
    /**
     * @return The specilized class used for this specific discriminator value.
     */
    Class<?> clazz();
}
