/***********************************************************
 *
 * ASN.1 Tools of the clazzes.org project
 * https://www.clazzes.org
 *
 * Created: 24.07.2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.asn1.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*
 * An ASN.1 serializable field. The field has to be equipped with
 * the likewise getters and setters.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ASN1Field {
    /**
     * The ASN.1 type to be used in serialized form.
     */
    ASN1Type type();

    /**
     * The sort order <code>1,2,&hellip;</code> in the serialized structure.
     */
    int order();
}
