/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.transactionprovider;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.clazzes.util.sql.transactionprovider.ClosableTransaction;
import org.clazzes.util.sql.transactionprovider.ClosableTransactionImpl;
import org.clazzes.util.sql.transactionprovider.TransactionException;
import org.clazzes.util.sql.transactionprovider.TransactionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProviderBlueprintImpl
implements TransactionProvider {
    private static final int DEFAULT_ISOLATION_LEVEL = -1;
    private static final Logger log = LoggerFactory.getLogger(TransactionProviderBlueprintImpl.class);
    private DataSource dataSource;
    private String threadLocalKey;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setThreadLocalKey(String threadLocalKey) {
        this.threadLocalKey = threadLocalKey;
    }

    @Override
    public ClosableTransaction getTransaction() {
        return this.getTransaction(this.threadLocalKey, -1);
    }

    @Override
    public ClosableTransaction getTransaction(int isolationLevel) {
        return this.getTransaction(this.threadLocalKey, isolationLevel);
    }

    @Override
    public ClosableTransaction getTransaction(String useThreadLocalKey) {
        return this.getTransaction(useThreadLocalKey, -1);
    }

    @Override
    public ClosableTransaction getTransaction(String useThreadLocalKey, int isolationLevel) {
        if (useThreadLocalKey == null) {
            throw new IllegalArgumentException("threadLocalKeyOverride");
        }
        Connection connection = this.getConnection();
        boolean previousAutoCommit = this.getPreviousAutoCommit(connection);
        int previousIsolationLevel = this.getPreviousIsolationLevel(connection);
        this.setNoAutoCommit(connection);
        this.setIsolationLevel(connection, isolationLevel);
        ThreadLocalManager.bindResource((String)useThreadLocalKey, (Object)connection);
        return new ClosableTransactionImpl(useThreadLocalKey, previousIsolationLevel, previousAutoCommit);
    }

    private boolean getPreviousAutoCommit(Connection connection) {
        try {
            return connection.getAutoCommit();
        }
        catch (SQLException e) {
            log.warn("SQLExcption while reading previous autoCommit and isolationLevel", (Throwable)e);
            return true;
        }
    }

    private int getPreviousIsolationLevel(Connection connection) {
        try {
            return connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            log.warn("SQLExcption while reading previous autoCommit and isolationLevel", (Throwable)e);
            return 2;
        }
    }

    private void setIsolationLevel(Connection connection, int isolationLevel) {
        try {
            if (isolationLevel != -1) {
                int originalIsolationLevel;
                if (log.isDebugEnabled()) {
                    log.debug("Starting JDBC transaction with isolation level [{}].", (Object)JDBCHelper.formatIsolationLevel(isolationLevel));
                }
                if ((originalIsolationLevel = connection.getTransactionIsolation()) != isolationLevel) {
                    connection.setTransactionIsolation(isolationLevel);
                }
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Error while setting isolation level.", e);
        }
    }

    @Override
    public boolean isActive() {
        return this.dataSource != null;
    }

    private Connection getConnection() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new TransactionException("Error while attempting to obtain a connection.", e);
        }
        return connection;
    }

    private void setNoAutoCommit(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TransactionException("Error while disabling autocommit.", e);
        }
    }
}

