/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.transactionprovider;

import java.util.function.Supplier;
import org.clazzes.util.sql.transactionprovider.ClosableTransaction;
import org.clazzes.util.sql.transactionprovider.TransactionException;

public interface TransactionProvider {
    default public <T> T transacted(Supplier<T> action) throws TransactionException {
        try (ClosableTransaction autoClose = this.getTransaction();){
            T result = action.get();
            autoClose.willCommit();
            T t = result;
            return t;
        }
    }

    public ClosableTransaction getTransaction();

    public ClosableTransaction getTransaction(int var1);

    public ClosableTransaction getTransaction(String var1);

    public ClosableTransaction getTransaction(String var1, int var2);

    public boolean isActive();
}

