/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.helper;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.i18n.I18nString;

public abstract class JDBCHelper {
    private static final String I18N_STRING_PATTERN_TRANSLATION = "([^\"]|\\\\\")*";
    private static final String I18N_STRING_PATTERN_MAPPING = "(\\s*\"[a-z]+\"\\s*:\\s*\"([^\"]|\\\\\")*\"\\s*)";
    private static final Pattern I18N_STRING_PATTERN = Pattern.compile("\\s*\\{(\\s*\"[a-z]+\"\\s*:\\s*\"([^\"]|\\\\\")*\"\\s*)?\\s*(\\,(\\s*\"[a-z]+\"\\s*:\\s*\"([^\"]|\\\\\")*\"\\s*)\\s*)*\\}\\s*");

    public static final String formatIsolationLevel(int isolationLevel) {
        switch (isolationLevel) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "TRANSACTION_ISOLATION_UNKNOWN" + isolationLevel;
    }

    public static Boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
        boolean b = rs.getBoolean(columnIndex);
        return rs.wasNull() ? null : Boolean.valueOf(b);
    }

    public static Boolean getBoolean(ResultSet rs, String columnLabel) throws SQLException {
        boolean b = rs.getBoolean(columnLabel);
        return rs.wasNull() ? null : Boolean.valueOf(b);
    }

    public static Byte getByte(ResultSet rs, int columnIndex) throws SQLException {
        byte b = rs.getByte(columnIndex);
        return rs.wasNull() ? null : Byte.valueOf(b);
    }

    public static Byte getByte(ResultSet rs, String columnLabel) throws SQLException {
        byte b = rs.getByte(columnLabel);
        return rs.wasNull() ? null : Byte.valueOf(b);
    }

    public static Short getShort(ResultSet rs, int columnIndex) throws SQLException {
        short s = rs.getShort(columnIndex);
        return rs.wasNull() ? null : Short.valueOf(s);
    }

    public static Short getShort(ResultSet rs, String columnLabel) throws SQLException {
        short s = rs.getShort(columnLabel);
        return rs.wasNull() ? null : Short.valueOf(s);
    }

    public static Integer getInt(ResultSet rs, int columnIndex) throws SQLException {
        int i = rs.getInt(columnIndex);
        return rs.wasNull() ? null : Integer.valueOf(i);
    }

    public static Integer getInt(ResultSet rs, String columnLabel) throws SQLException {
        int i = rs.getInt(columnLabel);
        return rs.wasNull() ? null : Integer.valueOf(i);
    }

    public static Long getLong(ResultSet rs, int columnIndex) throws SQLException {
        long l = rs.getLong(columnIndex);
        return rs.wasNull() ? null : Long.valueOf(l);
    }

    public static Long getLong(ResultSet rs, String columnLabel) throws SQLException {
        long l = rs.getLong(columnLabel);
        return rs.wasNull() ? null : Long.valueOf(l);
    }

    public static Float getFloat(ResultSet rs, int columnIndex) throws SQLException {
        float f = rs.getFloat(columnIndex);
        return rs.wasNull() ? null : Float.valueOf(f);
    }

    public static Float getFloat(ResultSet rs, String columnLabel) throws SQLException {
        float f = rs.getFloat(columnLabel);
        return rs.wasNull() ? null : Float.valueOf(f);
    }

    public static Double getDouble(ResultSet rs, int columnIndex) throws SQLException {
        double d = rs.getDouble(columnIndex);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    public static Double getDouble(ResultSet rs, String columnLabel) throws SQLException {
        double d = rs.getDouble(columnLabel);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    public static String getString(ResultSet rs, String columnLabel) throws SQLException {
        return rs.getString(columnLabel);
    }

    public static String getString(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getString(columnIndex);
    }

    public static Double getUtcSeconds(ResultSet resultSet, int columnIndex) throws SQLException {
        Timestamp timeStamp = resultSet.getTimestamp(columnIndex);
        return timeStamp == null ? null : Double.valueOf((double)timeStamp.getTime() * 0.001);
    }

    public static Instant getInstant(ResultSet resultSet, int columnIndex, ZoneId timeZone) throws SQLException {
        Timestamp timeStamp = resultSet.getTimestamp(columnIndex, timeZone == null ? null : Calendar.getInstance(TimeZone.getTimeZone(timeZone)));
        if (timeStamp == null) {
            return null;
        }
        return timeStamp.toInstant();
    }

    public static Instant getInstant(ResultSet resultSet, int columnIndex) throws SQLException {
        return JDBCHelper.getInstant(resultSet, columnIndex, null);
    }

    public static boolean isI18nMapString(String s) {
        return I18N_STRING_PATTERN.matcher(s).matches();
    }

    public static I18nString parseI18nString(String databaseString) {
        I18nString retString = new I18nString();
        int openBracketPosition = databaseString.indexOf("{");
        int closeBracketPosition = databaseString.lastIndexOf("}");
        if (openBracketPosition == -1 || closeBracketPosition == -1) {
            throw new IllegalArgumentException("Could not determine open/close bracket position in string [" + databaseString + "]; why didn't the RegExp check catch this?");
        }
        int currPos = openBracketPosition;
        while (currPos != -1 && currPos < closeBracketPosition) {
            int textQuotationMarkOpenPos;
            int languageQuotationMarkOpenPos = databaseString.indexOf("\"", currPos);
            int languageQuotationMarkClosePos = databaseString.indexOf("\"", languageQuotationMarkOpenPos + 1);
            if (languageQuotationMarkOpenPos == -1 || languageQuotationMarkClosePos == -1) break;
            String language = databaseString.substring(languageQuotationMarkOpenPos + 1, languageQuotationMarkClosePos);
            int colonPos = databaseString.indexOf(":", languageQuotationMarkClosePos);
            int currTextPos = textQuotationMarkOpenPos = databaseString.indexOf("\"", colonPos + 1);
            int textQuotationMarkEndPos = -1;
            while (true) {
                int backslashPos = databaseString.indexOf("\\", currTextPos + 1);
                textQuotationMarkEndPos = databaseString.indexOf("\"", currTextPos + 1);
                if (backslashPos == -1 || textQuotationMarkEndPos == -1 || backslashPos != textQuotationMarkEndPos - 1) break;
                currTextPos = textQuotationMarkEndPos;
            }
            String translation = databaseString.substring(textQuotationMarkOpenPos + 1, textQuotationMarkEndPos);
            if (retString.containsLanguage(language)) {
                throw new IllegalArgumentException("Parsed I18nString contains multiple translations for language [" + language + "]; one of the translations is [" + translation + "]; input string is [" + databaseString + "]");
            }
            retString.setTranslation(language, translation);
            currPos = databaseString.indexOf(",", textQuotationMarkEndPos);
        }
        return retString;
    }

    public static I18nString getI18nString(ResultSet resultSet, int columnIndex) throws SQLException {
        String databaseString = resultSet.getString(columnIndex);
        if (databaseString == null) {
            return null;
        }
        if (JDBCHelper.isI18nMapString(databaseString)) {
            return JDBCHelper.parseI18nString(databaseString);
        }
        Locale fallbackLocale = ThreadLocalManager.getFallbackLocale();
        if (fallbackLocale == null) {
            throw new DAOException("Cannot read string [" + databaseString + "] as I18nString, since it has not the correct format; additionally the fallback locale is missing.");
        }
        I18nString retString = new I18nString();
        retString.setTranslation(fallbackLocale.getLanguage(), databaseString);
        return retString;
    }

    public static void setBoolean(PreparedStatement ps, int parameterIndex, Boolean b) throws SQLException {
        if (b == null) {
            ps.setNull(parameterIndex, 16);
        } else {
            ps.setBoolean(parameterIndex, b);
        }
    }

    public static void setByte(PreparedStatement ps, int parameterIndex, Number b) throws SQLException {
        if (b == null) {
            ps.setNull(parameterIndex, -6);
        } else {
            ps.setByte(parameterIndex, b.byteValue());
        }
    }

    public static void setShort(PreparedStatement ps, int parameterIndex, Number s) throws SQLException {
        if (s == null) {
            ps.setNull(parameterIndex, 5);
        } else {
            ps.setShort(parameterIndex, s.shortValue());
        }
    }

    public static void setInt(PreparedStatement ps, int parameterIndex, Number i) throws SQLException {
        if (i == null) {
            ps.setNull(parameterIndex, 4);
        } else {
            ps.setInt(parameterIndex, i.intValue());
        }
    }

    public static void setLong(PreparedStatement ps, int parameterIndex, Number l) throws SQLException {
        if (l == null) {
            ps.setNull(parameterIndex, -5);
        } else {
            ps.setLong(parameterIndex, l.longValue());
        }
    }

    public static void setFloat(PreparedStatement ps, int parameterIndex, Number f) throws SQLException {
        if (f == null) {
            ps.setNull(parameterIndex, 6);
        } else {
            ps.setFloat(parameterIndex, f.floatValue());
        }
    }

    public static void setDouble(PreparedStatement ps, int parameterIndex, Number d) throws SQLException {
        if (d == null) {
            ps.setNull(parameterIndex, 8);
        } else {
            ps.setDouble(parameterIndex, d.doubleValue());
        }
    }

    public static void setString(PreparedStatement ps, int parameterIndex, String s) throws SQLException {
        ps.setString(parameterIndex, s);
    }

    public static void setUtcSeconds(PreparedStatement statement, int parameterIndex, Double utcSeconds) throws SQLException {
        if (utcSeconds == null) {
            statement.setNull(parameterIndex, 91);
        } else {
            long utcMillis = (long)(utcSeconds * 1000.0);
            Timestamp timeStamp = new Timestamp(utcMillis);
            statement.setTimestamp(parameterIndex, timeStamp);
        }
    }

    public static void setInstant(PreparedStatement statement, int parameterIndex, Instant instant, ZoneId timeZone) throws SQLException {
        if (instant == null) {
            statement.setNull(parameterIndex, 93);
        } else {
            statement.setTimestamp(parameterIndex, Timestamp.from(instant), timeZone == null ? null : Calendar.getInstance(TimeZone.getTimeZone(timeZone)));
        }
    }

    public static void setInstant(PreparedStatement statement, int parameterIndex, Instant instant) throws SQLException {
        JDBCHelper.setInstant(statement, parameterIndex, instant, null);
    }

    public static void setI18nString(PreparedStatement statement, int parameterIndex, I18nString i18nString) throws SQLException {
        StringBuilder s = new StringBuilder("{");
        Set languages = i18nString.getLanguages();
        boolean first = true;
        for (String language : languages) {
            String translation = i18nString.getTranslation(language);
            if (translation == null) continue;
            if (!first) {
                s.append(",");
            }
            s.append("\"");
            s.append(language);
            s.append("\":\"");
            s.append(translation);
            s.append("\"");
            first = false;
        }
        s.append("}");
        statement.setString(parameterIndex, s.toString());
    }

    public static <T extends Enum<T>> void setEnum(PreparedStatement statement, int pos, T val) throws SQLException {
        if (val == null) {
            statement.setNull(pos, 4);
        } else {
            statement.setInt(pos, val.ordinal());
        }
    }

    public static <T extends Enum<T>> T getEnum(ResultSet rs, int pos, Class<T> clazz) throws SQLException {
        int o = rs.getInt(pos);
        if (rs.wasNull()) {
            return null;
        }
        return (T)((Enum[])clazz.getEnumConstants())[o];
    }

    public static <T extends Enum<T>> void setEnumAsString(PreparedStatement statement, int pos, T val) throws SQLException {
        if (val == null) {
            statement.setNull(pos, 12);
        } else {
            statement.setString(pos, val.name());
        }
    }

    public static <T extends Enum<T>> T getEnumAsString(ResultSet rs, int pos, Class<T> clazz) throws SQLException {
        String s = rs.getString(pos);
        if (s == null) {
            return null;
        }
        return Enum.valueOf(clazz, s);
    }
}

