/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.ha;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.ha.IHaLock;
import org.clazzes.util.sql.ha.IHaLockManager;
import org.clazzes.util.sql.helper.JDBCTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHaLockManager
implements IHaLockManager {
    private static final Logger log = LoggerFactory.getLogger(SqlHaLockManager.class);
    private DataSource dataSource;
    private String connectionThreadLocalKey;
    private String nodeName;
    private String subSystem;
    private String tableName;
    public static final int STATUS_NO_LOCK = 2;
    public static final int STATUS_UNLOCKED = 0;
    public static final int STATUS_LOCKED = 1;

    public void initialize() throws SQLException {
        if (this.tableName == null) {
            log.info("Table name not configured, HA lock manager for subsystem [{}] is disabled.", (Object)this.subSystem);
            return;
        }
        if (this.dataSource == null) {
            log.warn("No JDBC datasource configured, HA lock manager for subsystem [{}] will not be initialized.", (Object)this.subSystem);
            return;
        }
        try (JDBCTransaction txn = new JDBCTransaction(this.dataSource, 8);){
            String sql = "select NODE_NAME,LOCK_TIME,UNLOCK_TIME,STATUS  from " + this.tableName + " where SUBSYSTEM=?";
            String oldNodeName = null;
            long oldLockTime = -1L;
            long oldUnlockTime = -1L;
            int oldStatus = -1;
            try (PreparedStatement ps = txn.getConnection().prepareStatement(sql);){
                ps.setString(1, this.subSystem);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        oldNodeName = rs.getString(1);
                        oldLockTime = rs.getLong(2);
                        oldUnlockTime = rs.getLong(3);
                        oldStatus = rs.getInt(4);
                    }
                }
            }
            if (oldNodeName == null) {
                log.info("Table [" + this.tableName + "] does not contain a row for subsystem [" + this.subSystem + "], creating one now.");
                String sql2 = "insert into " + this.tableName + " (SUBSYSTEM,NODE_NAME,LOCK_TIME,UNLOCK_TIME,STATUS) values (?,?,?,?,?)";
                long now = System.currentTimeMillis();
                try (PreparedStatement ps = txn.getConnection().prepareStatement(sql2);){
                    ps.setString(1, this.subSystem);
                    ps.setString(2, this.nodeName);
                    ps.setLong(3, now);
                    ps.setLong(4, now);
                    ps.setInt(5, 2);
                    ps.executeUpdate();
                }
            } else {
                log.info("Table [" + this.tableName + "] contains a row for subsystem [" + this.subSystem + "] with [NODE_NAME=" + oldNodeName + ",LOCK_TIME=" + oldLockTime + ",UNLOCK_TIME=" + oldUnlockTime + ",STATUS=" + oldStatus + "].");
            }
            txn.commit();
        }
    }

    protected long updateStatus(JDBCTransaction txn, int status) throws SQLException {
        long now = System.currentTimeMillis();
        String column = status == 0 ? "UNLOCK_TIME" : "LOCK_TIME";
        String sql = "update " + this.tableName + " set NODE_NAME=?, " + column + "=?, STATUS=? where SUBSYSTEM=?";
        if (log.isDebugEnabled()) {
            log.debug("Updating [" + this.tableName + "] for subsystem [" + this.subSystem + "] with [NODE_NAME=" + this.nodeName + "," + column + "=" + now + ",STATUS=" + status + "]...");
        }
        try (PreparedStatement ps = txn.getConnection().prepareStatement(sql);){
            ps.setString(1, this.nodeName);
            ps.setLong(2, now);
            ps.setInt(3, status);
            ps.setString(4, this.subSystem);
            ps.executeUpdate();
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully updated [" + this.tableName + "] for subsystem [" + this.subSystem + "] with [NODE_NAME=" + this.nodeName + "," + column + "=" + now + ",STATUS=" + status + "].");
        }
        return now;
    }

    protected SqlHaLock fetchAndLock(JDBCTransaction txn) throws SQLException {
        int oldStatus;
        long oldUnlockTime;
        long oldLockTime;
        String oldNodeName;
        block18: {
            if (log.isDebugEnabled()) {
                log.debug("Locking subsystem [{}] with node name [{}]", (Object)this.subSystem, (Object)this.nodeName);
            }
            String sql = "select NODE_NAME,LOCK_TIME,UNLOCK_TIME,STATUS  from " + this.tableName + " where SUBSYSTEM=? for update";
            try (PreparedStatement ps = txn.getConnection().prepareStatement(sql);){
                ps.setString(1, this.subSystem);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        oldNodeName = rs.getString(1);
                        oldLockTime = rs.getLong(2);
                        oldUnlockTime = rs.getLong(3);
                        oldStatus = rs.getInt(4);
                        break block18;
                    }
                    throw new SQLException("Table [" + this.tableName + "] does not contain a row for subsystem [" + this.subSystem + "].");
                }
            }
        }
        if (oldStatus == 1) {
            log.warn("Node [{}] has a stale lock on subsystem [{}] dating from [{}] to [{}]", new Object[]{oldNodeName, this.subSystem, oldUnlockTime, oldLockTime});
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Table [" + this.tableName + "] contains a row for subsystem [" + this.subSystem + "] with [NODE_NAME=" + oldNodeName + ",LOCK_TIME=" + oldLockTime + ",UNLOCK_TIME=" + oldUnlockTime + ",STATUS=" + oldStatus + "].");
            }
            if (oldStatus == 2) {
                oldNodeName = null;
            }
        }
        long lockTime = this.updateStatus(txn, 1);
        return new SqlHaLock(txn, lockTime, oldNodeName, oldLockTime, oldUnlockTime);
    }

    protected JDBCTransaction openTransaction() throws SQLException {
        if (this.connectionThreadLocalKey != null) {
            Connection conn = (Connection)ThreadLocalManager.getBoundResource((String)this.connectionThreadLocalKey);
            if (conn == null) {
                throw new DAOException("No connection bound under key [" + this.connectionThreadLocalKey + "], HA lock interceptor for subsystem [" + this.subSystem + "] called outside of a transaction context.");
            }
            return new JDBCTransaction(conn);
        }
        return new JDBCTransaction(this.dataSource, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHaLock doLock() throws SQLException {
        if (this.tableName == null) {
            if (log.isDebugEnabled()) {
                log.debug("HA lock manager for subsystem [{}] is disabled, not performing lock.", (Object)this.subSystem);
            }
            return null;
        }
        JDBCTransaction txn = this.openTransaction();
        try {
            SqlHaLock lock = this.fetchAndLock(txn);
            txn = null;
            SqlHaLock sqlHaLock = lock;
            return sqlHaLock;
        }
        finally {
            if (txn != null) {
                try {
                    txn.close();
                }
                catch (SQLException e) {
                    log.warn("Error while closing transaction after failed attempt to lock subsystem [" + this.subSystem + "]", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getSubSystem() {
        return this.subSystem;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        if (nodeName == null || nodeName.isEmpty()) {
            try {
                this.nodeName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                String uuidNodeName = UUID.randomUUID().toString();
                log.warn("Cannot determine local host name, using UUID [" + uuidNodeName + "] instead", (Throwable)e);
            }
        } else {
            this.nodeName = nodeName;
        }
    }

    public void setSubSystem(String subSystem) {
        this.subSystem = subSystem;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setConnectionThreadLocalKey(String connectionThreadLocalKey) {
        this.connectionThreadLocalKey = connectionThreadLocalKey;
    }

    public String getConnectionThreadLocalKey() {
        return this.connectionThreadLocalKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private final class SqlHaLock
    implements IHaLock {
        private JDBCTransaction txn;
        private final String lastNodeName;
        private final long lastLockTime;
        private final long lastUnlockTime;
        private final long lockTime;

        public SqlHaLock(JDBCTransaction txn, long lockTime, String lastNodeName, long lastLockTime, long lastUnlockTime) {
            this.txn = txn;
            this.lastNodeName = lastNodeName;
            this.lastLockTime = lastLockTime;
            this.lastUnlockTime = lastUnlockTime;
            this.lockTime = lockTime;
        }

        @Override
        public void close() throws Exception {
            if (this.txn != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Unlocking subsystem [{}] with node name [{}]", (Object)SqlHaLockManager.this.subSystem, (Object)SqlHaLockManager.this.nodeName);
                }
                try {
                    SqlHaLockManager.this.updateStatus(this.txn, 0);
                    this.txn.commit();
                }
                catch (SQLException e) {
                    log.warn("Error propagating unlocked status for subsystem [" + SqlHaLockManager.this.subSystem + "] and node [" + SqlHaLockManager.this.nodeName + "]");
                }
                JDBCTransaction tmp = this.txn;
                this.txn = null;
                tmp.close();
            }
        }

        @Override
        public long getLastLockTime() {
            return this.lastLockTime;
        }

        @Override
        public long getLastUnlockTime() {
            return this.lastUnlockTime;
        }

        @Override
        public long getLockTime() {
            return this.lockTime;
        }

        @Override
        public String getSubSystem() {
            return SqlHaLockManager.this.subSystem;
        }

        @Override
        public String getLastNodeName() {
            return this.lastNodeName;
        }

        @Override
        public String getNodeName() {
            return SqlHaLockManager.this.nodeName;
        }
    }
}

