/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.dao;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.sql.dao.IIdDAO;
import org.clazzes.util.sql.dao.MockIdGenerator;
import org.clazzes.util.sql.transactionprovider.ClosableTransaction;
import org.clazzes.util.sql.transactionprovider.TransactionException;
import org.clazzes.util.sql.transactionprovider.TransactionProvider;

public class MockIdDAO<T, I extends Serializable>
implements IIdDAO<T> {
    private final Deque<TransactionValues<T, I>> transactionValues = new ArrayDeque<TransactionValues<T, I>>();
    private final Map<I, T> rootValues = new HashMap<I, T>();
    private final Function<T, I> getIdFunction;
    private final BiConsumer<T, I> setIdFunction;
    private final Function<T, T> copy;
    private final Class<I> idClass;
    private Consumer<T> validator = null;
    private Supplier<DAOException> errorInjector = null;
    private boolean isInTransaction = false;

    public MockIdDAO(Function<T, I> getIdFunction, BiConsumer<T, I> setIdFunction, Function<T, T> copy, Class<I> idClass) {
        this.getIdFunction = getIdFunction;
        this.setIdFunction = setIdFunction;
        this.copy = copy;
        this.idClass = idClass;
    }

    private T getStoredDto(T dto) {
        I id = this.getId(dto);
        if (id == null && this.idClass == Long.class || this.idClass == Long.TYPE) {
            this.setIdFunction.accept(dto, MockIdGenerator.next());
        }
        T ret = this.copy.apply(dto);
        if (this.validator != null) {
            this.validator.accept(ret);
        }
        return ret;
    }

    private void checkErrorInjector() {
        DAOException error;
        if (this.errorInjector != null && (error = this.errorInjector.get()) != null) {
            throw error;
        }
    }

    @Override
    public T save(T dto_) {
        this.checkErrorInjector();
        if (this.getId(dto_) != null && this.get((Serializable)this.getId(dto_)) != null) {
            throw new DAOException("id must be unique");
        }
        T dto = this.getStoredDto(dto_);
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        Set deletedValues = transaction == null ? null : transaction.deletedValues;
        map.put(this.getId(dto), dto);
        if (deletedValues != null) {
            deletedValues.remove(this.getId(dto));
        }
        return dto;
    }

    @Override
    public List<T> saveBatch(List<T> dtos) {
        this.checkErrorInjector();
        HashSet<I> ids = new HashSet<I>();
        for (T dto : dtos) {
            I id = this.getId(dto);
            if (id == null) continue;
            if (ids.contains(id)) {
                throw new DAOException("id must be unique");
            }
            ids.add(id);
        }
        if (!this.getBatch((Collection<? extends Serializable>)ids).isEmpty()) {
            throw new DAOException("id must be unique");
        }
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        Set deletedValues = transaction == null ? null : transaction.deletedValues;
        for (T dto_ : dtos) {
            T dto = this.getStoredDto(dto_);
            map.put(this.getId(dto), dto);
            if (deletedValues == null) continue;
            deletedValues.remove(this.getId(dto));
        }
        return dtos;
    }

    private void commit(long id) {
        TransactionValues<T, I> commitedTransaction = this.transactionValues.pollLast();
        if (commitedTransaction == null || commitedTransaction.id != id) {
            throw new DAOException("mismatched commit/begin/rollback.");
        }
        TransactionValues<T, I> upperTransaction = this.transactionValues.peekLast();
        Map<I, T> map = upperTransaction == null ? this.rootValues : upperTransaction.values;
        Set deletedValues = upperTransaction == null ? null : upperTransaction.deletedValues;
        for (Serializable deletedId : commitedTransaction.deletedValues) {
            map.remove(deletedId);
            if (deletedValues == null) continue;
            deletedValues.add(deletedId);
        }
        for (Object dto : commitedTransaction.values.values()) {
            map.put(this.getId((T)dto), dto);
        }
    }

    private void rollback(long id) {
        TransactionValues<T, I> rolledbackTransaction = this.transactionValues.pollLast();
        if (rolledbackTransaction == null || rolledbackTransaction.id != id) {
            throw new DAOException("mismatched commit/begin/rollback.");
        }
    }

    @Override
    public int update(T dto) {
        this.checkErrorInjector();
        if (this.getId(dto) == null || this.get((Serializable)this.getId(dto)) == null) {
            throw new DAOException("update on non-existent dto.");
        }
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        map.put(this.getId(dto), dto);
        return 1;
    }

    @Override
    public int[] updateBatch(Collection<T> dtos) {
        this.checkErrorInjector();
        HashSet<I> ids = new HashSet<I>();
        for (T dto : dtos) {
            I id = this.getId(dto);
            if (id == null) {
                throw new DAOException("update must specifiy id.");
            }
            if (ids.contains(id)) {
                throw new DAOException("id must be unique");
            }
            ids.add(id);
        }
        if (this.getBatch((Collection<? extends Serializable>)ids).size() != ids.size()) {
            throw new DAOException("update on non-existent dto.");
        }
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        for (T dto : dtos) {
            map.put(this.getId(dto), dto);
        }
        return dtos.stream().mapToInt(a -> 1).toArray();
    }

    private <T1, T2, T3, T4> T2 reduceValues(TriFunction<Set<I>, Function<T4, T2>, T3, T1> processDeletedValues, TriFunction<Map<I, T>, Function<T3, T1>, T4, T2> processMap, T4 init) {
        Iterator<TransactionValues<T, I>> it = this.transactionValues.iterator();
        return this.reduceValuesImpl(processDeletedValues, processMap, it, init);
    }

    private <T4, T3, T1, T2> T2 reduceValuesImpl(TriFunction<Set<I>, Function<T4, T2>, T3, T1> processDeletedValues, TriFunction<Map<I, T>, Function<T3, T1>, T4, T2> processMap, Iterator<TransactionValues<T, I>> it, T4 v1) {
        if (it.hasNext()) {
            TransactionValues<T, I> transactionValues = it.next();
            return processMap.apply(transactionValues.values, v2 -> processDeletedValues.apply(transactionValues.deletedValues, v3 -> this.reduceValuesImpl(processDeletedValues, processMap, it, v3), v2), v1);
        }
        return processMap.apply(this.rootValues, null, v1);
    }

    @Override
    public List<T> getAll() {
        this.checkErrorInjector();
        HashSet seenIds = new HashSet();
        ArrayList ret = new ArrayList();
        this.reduceValues((deletedValues, rec, v) -> {
            seenIds.addAll(deletedValues);
            return rec == null ? null : rec.apply(null);
        }, (map, rec, v) -> {
            for (Object dto : map.values()) {
                if (seenIds.contains(this.getId((T)dto))) continue;
                seenIds.add(this.getId((T)dto));
                ret.add(dto);
            }
            return rec == null ? null : rec.apply(null);
        }, null);
        return ret;
    }

    @Override
    public T get(Serializable id_) {
        this.checkErrorInjector();
        return (T)this.reduceValues((deletedValues, rec, id) -> {
            if (deletedValues.contains(id)) {
                return null;
            }
            return rec == null ? null : rec.apply(id);
        }, (map, rec, id) -> {
            if (map.containsKey(id)) {
                return map.get(id);
            }
            return rec == null ? null : rec.apply(id);
        }, id_);
    }

    @Override
    public List<T> getBatch(Serializable ... ids) {
        return this.getBatch(Arrays.asList(ids));
    }

    @Override
    public List<T> getBatch(Collection<? extends Serializable> ids_) {
        this.checkErrorInjector();
        return this.reduceValues((deletedValues, rec, ids) -> {
            if (ids.isEmpty()) {
                return new ArrayList();
            }
            return rec == null ? new ArrayList() : (List)rec.apply((Collection)ids.stream().filter(id -> !deletedValues.contains(id)).collect(Collectors.toList()));
        }, (map, rec, ids) -> {
            if (ids.isEmpty()) {
                return new ArrayList();
            }
            ArrayList ret = rec == null ? new ArrayList() : (List)rec.apply((Collection)ids.stream().filter(id -> !map.containsKey(id)).collect(Collectors.toList()));
            ids.stream().filter(id -> map.containsKey(id)).map(id -> map.get(id)).forEach(ret::add);
            return ret;
        }, ids_);
    }

    @Override
    public boolean delete(Serializable id) {
        this.checkErrorInjector();
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        Set deletedValues = transaction == null ? null : transaction.deletedValues;
        map.remove(id);
        if (deletedValues != null) {
            deletedValues.add(id);
        }
        return true;
    }

    @Override
    public int[] deleteBatch(Collection<? extends Serializable> ids) {
        this.checkErrorInjector();
        TransactionValues<T, I> transaction = this.transactionValues.peekLast();
        Map<I, T> map = transaction == null ? this.rootValues : transaction.values;
        Set deletedValues = transaction == null ? null : transaction.deletedValues;
        for (Serializable serializable : ids) {
            map.remove(serializable);
            if (deletedValues == null) continue;
            deletedValues.add(serializable);
        }
        return ids.stream().mapToInt(a -> 1).toArray();
    }

    public I getId(T dto) {
        return (I)((Serializable)this.getIdFunction.apply(dto));
    }

    @Override
    public Class<I> getIdClass() {
        return this.idClass;
    }

    private ClosableTransaction transaction(final Runnable closer) {
        final long id = MockIdGenerator.next();
        this.transactionValues.addLast(new TransactionValues(id));
        return new ClosableTransaction(){
            boolean willCommit = false;

            @Override
            public void willCommit() {
                this.willCommit = true;
            }

            @Override
            public void willRollback() {
                this.willCommit = false;
            }

            @Override
            public void close() throws TransactionException {
                if (this.willCommit) {
                    MockIdDAO.this.commit(id);
                } else {
                    MockIdDAO.this.rollback(id);
                }
                if (closer != null) {
                    closer.run();
                }
            }
        };
    }

    public TransactionProvider transactionProvider() {
        return new TransactionProvider(){

            @Override
            public ClosableTransaction getTransaction() {
                if (MockIdDAO.this.isInTransaction) {
                    throw new TransactionException("nested transaction");
                }
                MockIdDAO.this.isInTransaction = true;
                return MockIdDAO.this.transaction(() -> {
                    MockIdDAO.this.isInTransaction = false;
                });
            }

            @Override
            public ClosableTransaction getTransaction(int isolationLevel) {
                return this.getTransaction();
            }

            @Override
            public ClosableTransaction getTransaction(String useThreadLocalKey) {
                throw new TransactionException("useThreadLocalKey should not be used.");
            }

            @Override
            public ClosableTransaction getTransaction(String useThreadLocalKey, int isolationLevel) {
                throw new TransactionException("useThreadLocalKey should not be used.");
            }

            @Override
            public boolean isActive() {
                return true;
            }
        };
    }

    public static TransactionProvider transactionProvider(MockIdDAO<?, ?> ... daos) {
        final List providers = Arrays.stream(daos).map(a -> a.transactionProvider()).collect(Collectors.toList());
        return new TransactionProvider(){

            @Override
            public ClosableTransaction getTransaction() {
                final List transactions = providers.stream().map(a -> a.getTransaction()).collect(Collectors.toList());
                return new ClosableTransaction(){

                    @Override
                    public void willCommit() {
                        transactions.forEach(ClosableTransaction::willCommit);
                    }

                    @Override
                    public void willRollback() {
                        transactions.forEach(ClosableTransaction::willRollback);
                    }

                    @Override
                    public void close() throws TransactionException {
                        transactions.forEach(ClosableTransaction::close);
                    }
                };
            }

            @Override
            public ClosableTransaction getTransaction(int isolationLevel) {
                return this.getTransaction();
            }

            @Override
            public ClosableTransaction getTransaction(String useThreadLocalKey) {
                throw new TransactionException("useThreadLocalKey should not be used.");
            }

            @Override
            public ClosableTransaction getTransaction(String useThreadLocalKey, int isolationLevel) {
                throw new TransactionException("useThreadLocalKey should not be used.");
            }

            @Override
            public boolean isActive() {
                return true;
            }
        };
    }

    public ClosableTransaction getTransaction() {
        return this.transaction(null);
    }

    public List<T> getAllNoIdValues() {
        return this.getAll().stream().map(dto -> {
            T ret = this.copy.apply(dto);
            this.setIdFunction.accept(ret, null);
            return ret;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T withErrorInjection(Supplier<DAOException> error, Supplier<T> fun) {
        Supplier<DAOException> prev = this.errorInjector;
        this.errorInjector = error;
        try {
            T t = fun.get();
            return t;
        }
        finally {
            this.errorInjector = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withValidator(Consumer<T> validator, Supplier<R> fun) {
        Consumer<T> prev = this.validator;
        this.validator = validator;
        try {
            R r = fun.get();
            return r;
        }
        finally {
            this.validator = prev;
        }
    }

    private static final class TransactionValues<T, I extends Serializable> {
        public final long id;
        public final Map<I, T> values = new HashMap<I, T>();
        public final Set<I> deletedValues = new HashSet<I>();

        public TransactionValues(long id) {
            this.id = id;
        }
    }

    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

