/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.criteria;

import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLValue;

public class SQLOrder
implements SQLFragment {
    private static final long serialVersionUID = 2012021401L;
    private SQLFragment fragment;
    private OrderDirection order;

    protected SQLOrder(SQLFragment fragment, OrderDirection order) {
        this.fragment = fragment;
        this.order = order;
    }

    public static SQLOrder forFragment(SQLFragment fragment, OrderDirection order) {
        return new SQLOrder(fragment, order);
    }

    public static SQLOrder forTableColumn(String tableName, String columnName, OrderDirection order) {
        SQLValue f = SQLValue.tableColumn(tableName, columnName);
        return new SQLOrder(f, order);
    }

    @Override
    public String toSQL(SQLDialect dialect) {
        if (this.order == null) {
            return "";
        }
        if (this.order == OrderDirection.ASC) {
            return this.fragment.toSQL(dialect) + " ASC";
        }
        return this.fragment.toSQL(dialect) + " DESC";
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }
}

