/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.criteria;

import java.util.Arrays;
import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCondition
implements SQLFragment {
    private static final Logger log = LoggerFactory.getLogger(SQLCondition.class);
    private static final long serialVersionUID = 7213686119989723324L;
    private final SQLFragment left;
    private final SQLFragment right;
    private final OperationType opType;

    protected SQLCondition(OperationType op, SQLFragment left, SQLFragment right) {
        this.left = left;
        this.right = right;
        this.opType = op;
    }

    protected static SQLCondition and(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.AND, operand1, operand2);
    }

    public static SQLCondition and(SQLFragment ... operands) {
        if (operands.length == 0) {
            return null;
        }
        if (operands.length == 1) {
            return new SQLCondition(OperationType.NOOP, operands[0], null);
        }
        if (operands.length == 2) {
            return SQLCondition.and(operands[0], operands[1]);
        }
        return SQLCondition.and(operands[0], (SQLFragment)SQLCondition.and(Arrays.copyOfRange(operands, 1, operands.length)));
    }

    protected static SQLCondition or(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.OR, operand1, operand2);
    }

    public static SQLCondition or(SQLFragment ... operands) {
        if (operands.length == 0) {
            return null;
        }
        if (operands.length == 1) {
            return new SQLCondition(OperationType.NOOP, operands[0], null);
        }
        if (operands.length == 2) {
            return SQLCondition.or(operands[0], operands[1]);
        }
        return SQLCondition.or(operands[0], (SQLFragment)SQLCondition.or(Arrays.copyOfRange(operands, 1, operands.length)));
    }

    public static SQLCondition eq(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.EQ, operand1, operand2);
    }

    public static SQLCondition notEq(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.NOT_EQ, operand1, operand2);
    }

    public static SQLCondition gt(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.GT, operand1, operand2);
    }

    public static SQLCondition gtEquals(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.GT_EQ, operand1, operand2);
    }

    public static SQLCondition lt(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.LT, operand1, operand2);
    }

    public static SQLCondition ltEquals(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.LT_EQ, operand1, operand2);
    }

    public static SQLCondition isNull(SQLFragment operand1) {
        return new SQLCondition(OperationType.IS_NULL, operand1, null);
    }

    public static SQLCondition notNull(SQLFragment operand1) {
        return new SQLCondition(OperationType.NOT_NULL, operand1, null);
    }

    public static SQLCondition like(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.LIKE, operand1, operand2);
    }

    public static SQLCondition in(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.IN, operand1, operand2);
    }

    public static SQLCondition notLike(SQLFragment operand1, SQLFragment operand2) {
        return new SQLCondition(OperationType.NOT_LIKE, operand1, operand2);
    }

    public static SQLCondition regexpLike(SQLFragment operand, SQLFragment regex) {
        return new SQLCondition(OperationType.REGEXP_LIKE, operand, regex);
    }

    public static SQLCondition notRegexpLike(SQLFragment operand, SQLFragment regex) {
        return new SQLCondition(OperationType.NOT_REGEXP_LIKE, operand, regex);
    }

    @Override
    public String toSQL(SQLDialect dialect) {
        StringBuffer result = new StringBuffer();
        block0 : switch (this.opType.ordinal()) {
            case 8: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(">");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 7: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(">=");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 10: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append("<");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 9: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append("<=");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 5: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append("=");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 6: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append("<>");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 11: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" IS NULL");
                break;
            }
            case 12: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" IS NOT NULL");
                break;
            }
            case 0: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" AND ");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 1: {
                switch (dialect) {
                    default: 
                }
                result.append("(");
                result.append(this.left.toSQL(dialect));
                result.append(" OR ");
                result.append(this.right.toSQL(dialect));
                result.append(")");
                break;
            }
            case 2: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" LIKE ");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 3: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" NOT LIKE ");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 4: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                result.append(" IN ");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 13: {
                switch (dialect) {
                    default: 
                }
                result.append(this.left.toSQL(dialect));
                break;
            }
            case 14: {
                switch (dialect) {
                    case ORACLE: {
                        result.append("REGEXP_LIKE( ");
                        result.append(this.left.toSQL(dialect));
                        result.append(", ");
                        result.append(this.right.toSQL(dialect));
                        result.append(" )");
                        break block0;
                    }
                    case MYSQL: {
                        result.append(this.left.toSQL(dialect));
                        result.append(" REGEXP ");
                        result.append(this.right.toSQL(dialect));
                        break block0;
                    }
                    case POSTGRES: {
                        result.append(this.left.toSQL(dialect));
                        result.append(" ~ ");
                        result.append(this.right.toSQL(dialect));
                        break block0;
                    }
                }
                log.warn("REGEXP_LIKE not support with dialect [{}], using LIKE instead.", (Object)dialect);
                result.append(this.left.toSQL(dialect));
                result.append(" LIKE ");
                result.append(this.right.toSQL(dialect));
                break;
            }
            case 15: {
                switch (dialect) {
                    case ORACLE: {
                        result.append("NOT REGEXP_LIKE( ");
                        result.append(this.left.toSQL(dialect));
                        result.append(", ");
                        result.append(this.right.toSQL(dialect));
                        result.append(" )");
                        break block0;
                    }
                    case MYSQL: {
                        result.append(this.left.toSQL(dialect));
                        result.append(" NOT REGEXP ");
                        result.append(this.right.toSQL(dialect));
                        break block0;
                    }
                    case POSTGRES: {
                        result.append(this.left.toSQL(dialect));
                        result.append(" !~ ");
                        result.append(this.right.toSQL(dialect));
                        break block0;
                    }
                }
                log.warn("NOT_REGEXP_LIKE not support with dialect [{}], using LIKE instead.", (Object)dialect);
                result.append(this.left.toSQL(dialect));
                result.append(" NOT LIKE ");
                result.append(this.right.toSQL(dialect));
            }
        }
        return result.toString();
    }

    private static enum OperationType {
        AND,
        OR,
        LIKE,
        NOT_LIKE,
        IN,
        EQ,
        NOT_EQ,
        GT_EQ,
        GT,
        LT_EQ,
        LT,
        IS_NULL,
        NOT_NULL,
        NOOP,
        REGEXP_LIKE,
        NOT_REGEXP_LIKE;

    }
}

