/***********************************************************
 * $Id: JDBCHelper.java 1258 2018-03-19 11:28:54Z util $
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.helper;

/** <p>Instances of this class represent a concrete
 *  instance of a foreign key relation.
 *  I.e.: ForeignEntity with
 *  <code>foreignId</code>&mdash;<code>foreignKeyAttribute</code>--&gt;<code>ownId</code>
 *  </p>
 *  
 *  <p>The purpose of this class is: A generated dmutils method
 *  queries, which foreign instances point to a particular own
 *  instance.  The result is returned in a List
 *  of instances of this class.
 * </p>
 * 
 * @author wpausch
 */
public class ForeignKeyInstance {

    /** The id of the instance the foreign key points to.
     */
    private Long ownId;
    
    /** The id of the instance containing the foreign key.
     */
    private Long foreignId;
    
    /** The name of the foreign entity.
     */
    private String foreignEntity;
    
    /** The name of the foreign key attribute.
     */
    private String foreignKeyAttribute;

    public Long getOwnId() {
        return this.ownId;
    }
    public void setOwnId(Long ownId) {
        this.ownId = ownId;
    }
    public Long getForeignId() {
        return this.foreignId;
    }
    public void setForeignId(Long foreignId) {
        this.foreignId = foreignId;
    }
    public String getForeignEntity() {
        return this.foreignEntity;
    }
    public void setForeignEntity(String foreignEntity) {
        this.foreignEntity = foreignEntity;
    }
    public String getForeignKeyAttribute() {
        return this.foreignKeyAttribute;
    }
    public void setForeignKeyAttribute(String foreignKeyAttribute) {
        this.foreignKeyAttribute = foreignKeyAttribute;
    }
}
