/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.helper;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.persistence.api.dto.IPersistent;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.sql.dao.IIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.BatchedDAOGetter;
import org.clazzes.util.sql.helper.BatchedDAOGetterMap;
import org.clazzes.util.sql.helper.BatchedExecutor;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.clazzes.util.sql.helper.StatementFiller;
import org.clazzes.util.sql.helper.SyncWithDBResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public static String getPlaceHolderSequence(int numberOfPlaceHolders) {
        if (numberOfPlaceHolders == 0) {
            return "NULL";
        }
        Object placeHolderString = "";
        for (int n = 0; n < numberOfPlaceHolders; ++n) {
            placeHolderString = (String)placeHolderString + "?" + (n < numberOfPlaceHolders - 1 ? ", " : "");
        }
        return placeHolderString;
    }

    public static int setIdsToStatement(PreparedStatement statement, int currIndex, List<Long> ids) throws SQLException {
        for (Long id : ids) {
            JDBCHelper.setLong(statement, currIndex++, id);
        }
        return currIndex;
    }

    public static int getNumberOfWildcards(String sql) {
        int position;
        int numberOfWildcards = 0;
        int currIndex = 0;
        while ((position = sql.indexOf("?", currIndex)) != -1) {
            currIndex = position + 1;
            ++numberOfWildcards;
        }
        return numberOfWildcards;
    }

    public static void checkNumberOfWildcards(String sql, int currIndex) {
        int numberOfWildcards = QueryHelper.getNumberOfWildcards(sql);
        if (numberOfWildcards != currIndex - 1) {
            throw new RuntimeException("Total number of wildcards: " + numberOfWildcards + "; number of set wildcards: " + (currIndex - 1) + "; please find the bug.");
        }
    }

    public static <T, L> List<T> executeDAOGetter(List<L> ids, int batchSize, BatchedDAOGetter<T, L> getter) {
        int delta;
        ArrayList<T> retList = new ArrayList<T>();
        for (int currOffset = 0; currOffset < ids.size(); currOffset += delta) {
            delta = batchSize;
            List<L> currIds = ids.subList(currOffset, Math.min(currOffset + delta, ids.size()));
            retList.addAll(getter.execute(currIds));
        }
        return retList;
    }

    public static <T, L> Map<L, T> executeDAOGetter(List<L> ids, int batchSize, BatchedDAOGetterMap<T, L> getter) {
        int delta;
        HashMap<L, T> retMap = new HashMap<L, T>();
        for (int currOffset = 0; currOffset < ids.size(); currOffset += delta) {
            delta = batchSize;
            List<L> currIds = ids.subList(currOffset, Math.min(currOffset + delta, ids.size()));
            retMap.putAll(getter.execute(currIds));
        }
        return retMap;
    }

    public static <L> void executeBatch(List<L> ids, int batchSize, BatchedExecutor<L> executor) {
        int delta;
        for (int currOffset = 0; currOffset < ids.size(); currOffset += delta) {
            delta = batchSize;
            List<L> currIds = ids.subList(currOffset, Math.min(currOffset + delta, ids.size()));
            executor.execute(currIds);
        }
    }

    public static byte[] encodeStringForDatabaseBlob(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Long> getPersistentIds(List<? extends IPersistent> persistents) {
        ArrayList<Long> persistentIds = new ArrayList<Long>();
        for (IPersistent iPersistent : persistents) {
            persistentIds.add(iPersistent.getId());
        }
        return persistentIds;
    }

    public static Set<Long> getPersistentIdsSet(List<? extends IPersistent> persistents) {
        HashSet<Long> persistentIds = new HashSet<Long>();
        for (IPersistent iPersistent : persistents) {
            persistentIds.add(iPersistent.getId());
        }
        return persistentIds;
    }

    public static String trimOptionalFieldValue(String s) {
        String string = s = s != null ? s.trim() : null;
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String trimMandatoryFieldValue(String s, String fieldName) {
        String string = s = s != null ? s.trim() : null;
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is mandatory, but missing.  Please provide a value.");
        }
        return s;
    }

    public static <T> T checkMandatoryValue(T value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is mandatory, but missing. Please provider a value.");
        }
        return value;
    }

    public static <T> List<T> getListWithSql(JdbcDAOSupport dao, String sql, ResultSetMapper<T> mapper, StatementPreparer preparer) {
        Connection con = (Connection)ThreadLocalManager.getBoundResource((String)dao.getThreadLocalKey());
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(sql);
            preparer.fillInsertValues(statement);
            ArrayList<T> ret = new ArrayList<T>();
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                ret.add(mapper.map(rs));
            }
            ArrayList<T> arrayList = ret;
            return arrayList;
        }
        catch (Exception e) {
            throw new DAOException((Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn("Error when closing prepared statement.", (Throwable)e);
                }
            }
        }
    }

    public static <T> List<T> getListWithSqlFiller(JdbcDAOSupport dao, String sql, ResultSetMapper<T> mapper, StatementPreparerUsingFiller preparer) {
        return QueryHelper.getListWithSql(dao, sql, mapper, statement -> preparer.prepare(new StatementFiller(statement)));
    }

    public static <T> T getUniqueWithSql(JdbcDAOSupport dao, String sql, ResultSetMapper<T> mapper, StatementPreparer preparer) {
        Connection con = (Connection)ThreadLocalManager.getBoundResource((String)dao.getThreadLocalKey());
        PreparedStatement statement = null;
        try {
            statement = con.prepareStatement(sql);
            preparer.fillInsertValues(statement);
            Object ret = null;
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (ret != null) {
                    throw new DAOException("getUniqueWithCondition found multiple  instances of [" + ret.getClass().getSimpleName() + "] where at most one was expected.");
                }
                ret = mapper.map(rs);
            }
            Object object = ret;
            return (T)object;
        }
        catch (Exception e) {
            throw new DAOException((Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    log.warn("Error when closing prepared statement.", (Throwable)e);
                }
            }
        }
    }

    public static <T extends IPersistent> SyncWithDBResult<T> syncWithDatabase(IIdDAO<T> dao, List<T> newPersistents, List<T> oldPersistents) {
        return QueryHelper.syncWithDatabase(dao, newPersistents, oldPersistents, false);
    }

    public static <T extends IPersistent> SyncWithDBResult<T> syncWithDatabase(IIdDAO<T> dao, List<T> newPersistents, List<T> oldPersistents, boolean skipDelete) {
        Long id;
        ArrayList<IPersistent> persistentsToSave = new ArrayList<IPersistent>();
        ArrayList<IPersistent> persistentsToUpdate = new ArrayList<IPersistent>();
        ArrayList<Long> persistentIdsToDelete = new ArrayList<Long>();
        HashSet<Long> oldPersistentIds = new HashSet<Long>();
        for (IPersistent oldPersistent : oldPersistents) {
            oldPersistentIds.add(oldPersistent.getId());
        }
        HashSet<Long> newPersistentIds = new HashSet<Long>();
        ArrayList<IPersistent> retValues = new ArrayList<IPersistent>();
        HashMap<Integer, Integer> toSaveIndexToRetIndex = new HashMap<Integer, Integer>();
        for (IPersistent newPersistent : newPersistents) {
            id = newPersistent.getId();
            if (id != null && !oldPersistentIds.contains(id)) {
                newPersistent.setId(null);
                toSaveIndexToRetIndex.put(persistentsToSave.size(), retValues.size());
                persistentsToSave.add(newPersistent);
                retValues.add(newPersistent);
                continue;
            }
            if (id == null) {
                toSaveIndexToRetIndex.put(persistentsToSave.size(), retValues.size());
                persistentsToSave.add(newPersistent);
                retValues.add(newPersistent);
                continue;
            }
            persistentsToUpdate.add(newPersistent);
            newPersistentIds.add(id);
            retValues.add(newPersistent);
        }
        for (Object oldPersistent : oldPersistents) {
            id = oldPersistent.getId();
            if (newPersistentIds.contains(id)) continue;
            persistentIdsToDelete.add(id);
        }
        if (!persistentsToSave.isEmpty()) {
            List savedPersistents = dao.saveBatch(persistentsToSave);
            for (Integer toSaveIndex : toSaveIndexToRetIndex.keySet()) {
                Integer retIndex = (Integer)toSaveIndexToRetIndex.get(toSaveIndex);
                retValues.set(retIndex, (IPersistent)savedPersistents.get(toSaveIndex));
            }
        }
        if (!persistentsToUpdate.isEmpty()) {
            dao.updateBatch(persistentsToUpdate);
        }
        SyncWithDBResult<IPersistent> result = new SyncWithDBResult<IPersistent>();
        if (!skipDelete && !persistentIdsToDelete.isEmpty()) {
            try {
                dao.deleteBatch(persistentIdsToDelete);
            }
            catch (Exception e) {
                for (Long persistentIdToDelete : persistentIdsToDelete) {
                    try {
                        dao.delete(persistentIdToDelete);
                    }
                    catch (Exception e2) {
                        result.addNotDeletableId(persistentIdToDelete);
                    }
                }
            }
        }
        result.setInstances(retValues);
        return result;
    }

    public static <T> void syncWithDatabaseByMap(IIdDAO<T> dao, Map<Long, T> idToNewItem, Map<Long, T> idToOldItem) {
        QueryHelper.syncWithDatabaseByMap(dao, idToNewItem, idToOldItem, false);
    }

    public static <T> void syncWithDatabaseByMap(IIdDAO<T> dao, Map<Long, T> idToNewItem, Map<Long, T> idToOldItem, boolean skipDelete) {
        ArrayList<T> saveItems = new ArrayList<T>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        ArrayList<T> updateItems = new ArrayList<T>();
        for (Long id : idToNewItem.keySet()) {
            T item = idToNewItem.get(id);
            if (idToOldItem.containsKey(id)) {
                updateItems.add(item);
                continue;
            }
            saveItems.add(item);
        }
        for (Long id : idToOldItem.keySet()) {
            if (idToNewItem.containsKey(id)) continue;
            deleteIds.add(id);
        }
        if (saveItems.size() > 0) {
            dao.saveBatch(saveItems);
        }
        if (updateItems.size() > 0) {
            dao.updateBatch(updateItems);
        }
        if (!skipDelete && deleteIds.size() > 0) {
            dao.deleteBatch(deleteIds);
        }
    }

    public static <T> T getUniqueWithSqlFiller(JdbcDAOSupport dao, String sql, ResultSetMapper<T> mapper, StatementPreparerUsingFiller preparer) {
        return QueryHelper.getUniqueWithSql(dao, sql, mapper, statement -> preparer.prepare(new StatementFiller(statement)));
    }

    public static String getLengthFunctionName(JdbcDAOSupport dao) {
        Connection con = (Connection)ThreadLocalManager.getBoundResource((String)dao.getThreadLocalKey());
        try {
            if ("Microsoft SQL Server".equals(con.getMetaData().getDatabaseProductName())) {
                return "LEN";
            }
            return "LENGTH";
        }
        catch (SQLException e) {
            log.warn("Error when trying to determine database product.", (Throwable)e);
            return "LENGTH";
        }
    }

    public static String getLimitClause(JdbcDAOSupport dao, String number, boolean hasOrderBy) {
        Connection con = (Connection)ThreadLocalManager.getBoundResource((String)dao.getThreadLocalKey());
        try {
            if ("Microsoft SQL Server".equals(con.getMetaData().getDatabaseProductName())) {
                if (hasOrderBy) {
                    return "OFFSET 0 ROWS\nFETCH NEXT " + number + " ROWS ONLY\n";
                }
                return "ORDER BY 0\nOFFSET 0 ROWS\nFETCH NEXT " + number + " ROWS ONLY\n";
            }
        }
        catch (SQLException e) {
            log.warn("Error when trying to determine database product.", (Throwable)e);
        }
        return "LIMIT " + number + "\n";
    }

    public static String getLimitClause(JdbcDAOSupport dao, String number) {
        return QueryHelper.getLimitClause(dao, number, true);
    }

    @FunctionalInterface
    public static interface ResultSetMapper<T> {
        public T map(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface StatementPreparerUsingFiller {
        public void prepare(StatementFiller var1) throws SQLException;
    }
}

