/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.helper;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTransaction
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JDBCTransaction.class);
    private final int isolationLevel;
    private final boolean doCloseConnection;
    private Connection connection;
    private int originalIsolationLevel;

    protected void startTransaction() throws SQLException {
        if (this.isolationLevel != -1) {
            if (log.isDebugEnabled()) {
                log.debug("Starting JDBC transaction with isolation level [{}].", (Object)JDBCHelper.formatIsolationLevel(this.isolationLevel));
            }
            this.originalIsolationLevel = this.connection.getTransactionIsolation();
            if (this.originalIsolationLevel != this.isolationLevel) {
                this.connection.setTransactionIsolation(this.isolationLevel);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Starting JDBC transaction with default isolation level.");
        }
        this.connection.setAutoCommit(false);
    }

    protected void dropConnection() {
        if (this.originalIsolationLevel != this.isolationLevel) {
            try {
                this.connection.setTransactionIsolation(this.originalIsolationLevel);
            }
            catch (SQLException e) {
                log.warn("Error resetting isolation level from [" + JDBCHelper.formatIsolationLevel(this.isolationLevel) + "] to [" + JDBCHelper.formatIsolationLevel(this.originalIsolationLevel) + "]", (Throwable)e);
            }
        }
        if (this.doCloseConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                log.warn("Error closing JDBC connection", (Throwable)e);
            }
        }
        this.connection = null;
    }

    protected static Connection fetchConnection(DataSource dataSource) throws SQLException {
        Connection connection;
        if (log.isTraceEnabled()) {
            long now = System.currentTimeMillis();
            log.trace("Fetching connection from datasource [{}].", (Object)dataSource);
            connection = dataSource.getConnection();
            long duration = System.currentTimeMillis() - now;
            log.trace("Opening transaction for datasource [{}], fetch took [{}] milliseconds.", (Object)dataSource, (Object)duration);
        } else {
            connection = dataSource.getConnection();
        }
        return connection;
    }

    public JDBCTransaction(DataSource dataSource) throws SQLException {
        this.connection = JDBCTransaction.fetchConnection(dataSource);
        this.doCloseConnection = true;
        this.isolationLevel = -1;
        this.originalIsolationLevel = -1;
        this.startTransaction();
    }

    public JDBCTransaction(DataSource dataSource, int isolationLevel) throws SQLException {
        this.connection = JDBCTransaction.fetchConnection(dataSource);
        this.doCloseConnection = true;
        this.isolationLevel = isolationLevel;
        this.startTransaction();
    }

    public JDBCTransaction(Connection connection) throws SQLException {
        this.connection = connection;
        this.doCloseConnection = false;
        this.isolationLevel = -1;
        this.originalIsolationLevel = -1;
        this.startTransaction();
    }

    public JDBCTransaction(Connection connection, int isolationLevel) throws SQLException {
        this.connection = connection;
        this.doCloseConnection = false;
        this.isolationLevel = isolationLevel;
        this.startTransaction();
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Committing JDBC transaction.");
        }
        this.connection.commit();
        this.dropConnection();
    }

    public void rollback() throws SQLException {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            if (log.isDebugEnabled()) {
                log.debug("Rolling back JDBC transaction.");
            }
            try {
                this.connection.rollback();
            }
            finally {
                this.dropConnection();
            }
        }
    }
}

