/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLStatementGenerator;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLOrder;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AppendListEntityConsumer;
import org.clazzes.util.sql.dao.IBasicDAO;
import org.clazzes.util.sql.dao.IEntityConsumer;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstrBasicDAO<T>
extends JdbcDAOSupport
implements IBasicDAO<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstrBasicDAO.class);
    private final String tableName;
    private final String[] columnNames;
    private final String[] writableColumnNames;
    private SQLStatementGenerator generator;

    public AbstrBasicDAO(String tableName, String ... columnNames) {
        this(tableName, columnNames, columnNames);
    }

    public AbstrBasicDAO(String tableName, String[] columnNames, String[] writableColumnNames) {
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.writableColumnNames = writableColumnNames;
    }

    @Override
    public abstract int update(T var1);

    @Override
    public int[] updateBatch(Collection<T> dtos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T save(final T dto) {
        String sql = this.getGenerator().insert(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (T)this.performWithPreparedStatement(sql, new JdbcPreparedStatementAction<T>(){

            public T perform(PreparedStatement statement) throws SQLException {
                AbstrBasicDAO.this.fillPreparedStatementFromDto(statement, dto);
                statement.executeUpdate();
                return dto;
            }
        });
    }

    @Override
    public List<T> saveBatch(final List<T> dtos) {
        if (dtos.size() == 0) {
            return dtos;
        }
        String sql = this.getGenerator().insert(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getWritableColumnNames()));
        if (log.isDebugEnabled()) {
            log.debug("executing query [" + sql + "]");
        }
        return (List)this.performWithPreparedStatement(sql, new JdbcPreparedStatementAction<List<T>>(){

            public List<T> perform(PreparedStatement statement) throws SQLException {
                for (Object dto : dtos) {
                    AbstrBasicDAO.this.fillPreparedStatementFromDto(statement, dto);
                    statement.addBatch();
                }
                statement.executeBatch();
                return dtos;
            }
        });
    }

    protected abstract T fillDtoFromResultSet(ResultSet var1) throws SQLException;

    protected abstract void fillPreparedStatementFromDto(PreparedStatement var1, T var2) throws SQLException;

    protected String getSelectSqlForCondition(SQLCondition condition, SQLOrder[] orders) {
        return this.getGenerator().select(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getColumnNames()), condition, orders);
    }

    protected String getSelectForUpdateSqlForCondition(SQLCondition condition, SQLOrder[] orders) {
        return this.getGenerator().selectForUpdate(this.getTableName(), SQLValue.columnList(this.getTableName(), this.getColumnNames()), condition, orders);
    }

    protected String getSelectSqlForCondition(SQLCondition condition) {
        return this.getSelectSqlForCondition(condition, null);
    }

    protected String getSelectForUpdateSqlForCondition(SQLCondition condition) {
        return this.getSelectSqlForCondition(condition, null);
    }

    protected List<T> getListWithCondition(SQLCondition condition, StatementPreparer preparer) {
        return this.getSubList(condition, preparer, null, -1, -1);
    }

    protected List<T> getListWithConditionForUpdate(SQLCondition condition, StatementPreparer preparer) {
        return this.getSubListForUpdate(condition, preparer, null, -1, -1);
    }

    protected List<T> getListWithSql(String sql, StatementPreparer preparer) {
        return this.getSubListWithSql(sql, preparer, -1, -1);
    }

    protected long getListSize(SQLCondition condition, final StatementPreparer preparer) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) FROM ");
        sql.append(this.getTableName());
        if (condition != null) {
            sql.append(" WHERE ");
            sql.append(condition.toSQL(this.getGenerator().getDialect()));
        }
        return (Long)this.performWithPreparedStatement(sql.toString(), (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Long>(){

            public Long perform(PreparedStatement statement) throws Exception {
                ResultSet rs;
                if (preparer != null) {
                    preparer.fillInsertValues(statement);
                }
                if ((rs = statement.executeQuery()) == null) {
                    return 0L;
                }
                if (!rs.next()) {
                    return 0L;
                }
                return rs.getLong(1);
            }
        });
    }

    protected List<T> getSubList(SQLCondition condition, StatementPreparer preparer, SQLOrder[] orders, int rowsToSkip, int maxRows) {
        return this.getSubListWithSql(this.getSelectSqlForCondition(condition, orders), preparer, rowsToSkip, maxRows);
    }

    protected List<T> getSubListForUpdate(SQLCondition condition, StatementPreparer preparer, SQLOrder[] orders, int rowsToSkip, int maxRows) {
        return this.getSubListWithSql(this.getSelectForUpdateSqlForCondition(condition, orders), preparer, rowsToSkip, maxRows);
    }

    protected List<T> getSubListWithSql(String sql, StatementPreparer preparer, int rowsToSkip, int maxRows) {
        ArrayList list = new ArrayList(Math.max(maxRows, 10));
        AppendListEntityConsumer consumer = new AppendListEntityConsumer(list);
        this.streamSubListWithSql(consumer, sql, preparer, rowsToSkip, maxRows);
        return list;
    }

    protected int streamListWithCondition(IEntityConsumer<T> entityConsumer, SQLCondition condition, StatementPreparer preparer) {
        return this.streamSubList(entityConsumer, condition, preparer, null, -1, -1);
    }

    protected int streamListWithSql(IEntityConsumer<T> entityConsumer, String sql, StatementPreparer preparer) {
        return this.streamSubListWithSql(entityConsumer, sql, preparer, -1, -1);
    }

    protected int streamSubList(IEntityConsumer<T> entityConsumer, SQLCondition condition, StatementPreparer preparer, SQLOrder[] orders, int rowsToSkip, int maxRows) {
        return this.streamSubListWithSql(entityConsumer, this.getSelectSqlForCondition(condition, orders), preparer, rowsToSkip, maxRows);
    }

    protected int streamSubListForUpdate(IEntityConsumer<T> entityConsumer, SQLCondition condition, StatementPreparer preparer, SQLOrder[] orders, int rowsToSkip, int maxRows) {
        return this.streamSubListWithSql(entityConsumer, this.getSelectForUpdateSqlForCondition(condition, orders), preparer, rowsToSkip, maxRows);
    }

    protected int streamSubListWithSql(final IEntityConsumer<T> entityConsumer, String sql, final StatementPreparer preparer, final int rowsToSkip, final int maxRows) {
        return (Integer)this.performWithPreparedStatement(sql, rowsToSkip > 0 ? 1004 : 1003, 1007, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Integer>(){

            public Integer perform(PreparedStatement statement) throws Exception {
                int nEntities;
                if (preparer != null) {
                    preparer.fillInsertValues(statement);
                }
                if (maxRows >= 0) {
                    statement.setFetchSize(maxRows == 0 ? 1 : maxRows);
                    if (rowsToSkip > 0) {
                        statement.setMaxRows(rowsToSkip + maxRows);
                    }
                }
                ResultSet rs = statement.executeQuery();
                if (rowsToSkip > 0) {
                    rs.absolute(rowsToSkip);
                }
                for (nEntities = 0; rs.next() && (maxRows < 0 || nEntities < maxRows); ++nEntities) {
                    entityConsumer.consumeEntity(AbstrBasicDAO.this.fillDtoFromResultSet(rs));
                }
                return nEntities;
            }
        });
    }

    protected T getUniqueWithSql(String sql, final StatementPreparer preparer) {
        return (T)this.performWithPreparedStatement(sql, new JdbcPreparedStatementAction<T>(){

            public T perform(PreparedStatement statement) throws Exception {
                if (preparer != null) {
                    preparer.fillInsertValues(statement);
                }
                ResultSet rs = statement.executeQuery();
                Object ret = null;
                while (rs.next()) {
                    if (ret != null) {
                        throw new DAOException("getUniqueWithSql found multiple  instances of [" + AbstrBasicDAO.this.getTableName() + "] where at most one was expected.");
                    }
                    ret = AbstrBasicDAO.this.fillDtoFromResultSet(rs);
                }
                return ret;
            }
        });
    }

    protected T getUniqueWithCondition(SQLCondition condition, StatementPreparer preparer) {
        String sql = this.getSelectSqlForCondition(condition);
        return this.getUniqueWithSql(sql, preparer);
    }

    protected T getUniqueWithConditionForUpdate(SQLCondition condition, StatementPreparer preparer) {
        String sql = this.getSelectForUpdateSqlForCondition(condition);
        return this.getUniqueWithSql(sql, preparer);
    }

    protected int deleteWithCondition(SQLCondition condition, final StatementPreparer preparer) {
        String sql = this.getGenerator().delete(this.getTableName(), condition);
        return (Integer)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Integer>(){

            public Integer perform(PreparedStatement statement) throws Exception {
                if (preparer != null) {
                    preparer.fillInsertValues(statement);
                }
                return statement.executeUpdate();
            }
        });
    }

    @Override
    public List<T> getAll() {
        return this.getSubList(null, null, null, -1, -1);
    }

    @Override
    public List<T> getAllForUpdate() {
        return this.getSubListForUpdate(null, null, null, -1, -1);
    }

    public void setGenerator(SQLStatementGenerator generator) {
        this.generator = generator;
    }

    public SQLStatementGenerator getGenerator() {
        return this.generator;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getWritableColumnNames() {
        return this.writableColumnNames;
    }

    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }
}

