/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.criteria;

import org.apache.commons.lang.StringEscapeUtils;
import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;

public class SQLValue
implements SQLFragment {
    private static final long serialVersionUID = -7768523896059257899L;
    public static final SQLValue INSERT_VALUE = new SQLValue(ValueType.PLACEHOLDER, "?");
    private String[] values;
    private ValueType type;

    protected SQLValue(ValueType type, String ... values) {
        this.type = type;
        this.values = values;
    }

    public static SQLValue integerValue(long longValue) {
        return new SQLValue(ValueType.INTEGER_VALUE, Long.toString(longValue));
    }

    public static SQLValue stringValue(String value) {
        return new SQLValue(ValueType.STRING_VALUE, value);
    }

    public static SQLValue tableColumn(String tableName, String columnName) {
        return new SQLValue(ValueType.TABLE_COLUMN, tableName, columnName);
    }

    public static SQLValue[] valueList(SQLValue ... values) {
        return values;
    }

    public static SQLValue[] columnList(String tableName, String ... columnNames) {
        SQLValue[] results = new SQLValue[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            results[i] = new SQLValue(ValueType.TABLE_COLUMN, tableName, columnNames[i]);
        }
        return results;
    }

    @Override
    public String toSQL(SQLDialect dialect) {
        switch (this.type) {
            case TABLE_COLUMN: {
                switch (dialect) {
                    default: 
                }
                return this.values[0] + "." + this.values[1];
            }
            case PLACEHOLDER: 
            case INTEGER_VALUE: {
                switch (dialect) {
                    default: 
                }
                return this.values[0];
            }
            case STRING_VALUE: {
                switch (dialect) {
                    default: 
                }
                return "'" + StringEscapeUtils.escapeSql((String)this.values[0]) + "'";
            }
        }
        return null;
    }

    public String toUnqualifiedSQL(SQLDialect dialect) {
        if (this.type == ValueType.TABLE_COLUMN) {
            return this.values[1];
        }
        return this.toSQL(dialect);
    }

    public static enum ValueType {
        TABLE_COLUMN,
        PLACEHOLDER,
        INTEGER_VALUE,
        STRING_VALUE;

    }
}

