/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql.criteria;

import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;

public class SQLConstruct
implements SQLFragment {
    private static final long serialVersionUID = -5890504692911862897L;
    private SQLFragment[] content;
    private ConstructType type;
    private LinkType link;

    protected SQLConstruct(ConstructType type, LinkType link, SQLFragment ... contents) {
        this.type = type;
        this.link = link;
        this.content = contents;
    }

    public static SQLConstruct parenthesis(SQLFragment ... contents) {
        return new SQLConstruct(ConstructType.PARENTHESIS, LinkType.NONE, contents);
    }

    public static SQLConstruct commaParenthesis(SQLFragment ... contents) {
        return new SQLConstruct(ConstructType.PARENTHESIS, LinkType.COMMA, contents);
    }

    public static SQLConstruct commaSeperated(SQLFragment ... contents) {
        return new SQLConstruct(ConstructType.NONE, LinkType.COMMA, contents);
    }

    @Override
    public String toSQL(SQLDialect dialect) {
        StringBuffer result = new StringBuffer();
        switch (this.type) {
            case PARENTHESIS: {
                switch (dialect) {
                    default: 
                }
                result.append("(");
                this.list(result, dialect);
                result.append(")");
                break;
            }
            case NONE: {
                switch (dialect) {
                    default: 
                }
                this.list(result, dialect);
            }
        }
        return result.toString();
    }

    private void list(StringBuffer result, SQLDialect dialect) {
        block4: for (int i = 0; i < this.content.length; ++i) {
            result.append(this.content[i].toSQL(dialect));
            if (this.content.length - i <= 1) continue;
            switch (this.link) {
                case COMMA: {
                    result.append(", ");
                    continue block4;
                }
                case NONE: {
                    result.append(" ");
                    continue block4;
                }
            }
        }
    }

    protected static enum ConstructType {
        PARENTHESIS,
        NONE;

    }

    protected static enum LinkType {
        COMMA,
        NONE;

    }
}

