/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.util.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.clazzes.util.sql.SQLDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLDialectFactory {
    private static final Logger log = LoggerFactory.getLogger(SQLDialectFactory.class);

    public static final SQLDialect getSQLDialect(String databaseProduct) {
        SQLDialect ret = SQLDialect.ISO;
        if (databaseProduct.contains("MariaDB") || databaseProduct.contains("MySQL")) {
            ret = SQLDialect.MYSQL;
        } else if (databaseProduct.contains("Oracle")) {
            ret = SQLDialect.ORACLE;
        } else if (databaseProduct.contains("Microsoft SQL Server")) {
            ret = SQLDialect.MSSQL;
        } else if (databaseProduct.contains("PostgreSQL")) {
            ret = SQLDialect.POSTGRES;
        } else if (databaseProduct.contains("Apache Derby")) {
            ret = SQLDialect.DERBY;
        } else {
            log.warn("DB product [{}] is unknown, will use [{}] as dialect.", (Object)databaseProduct, (Object)ret);
        }
        log.info("Using DML dialect [{}] for DB product [{}].", (Object)ret, (Object)databaseProduct);
        return ret;
    }

    public static final SQLDialect getSQLDialect(DatabaseMetaData metaData) throws SQLException {
        return SQLDialectFactory.getSQLDialect(metaData.getDatabaseProductName());
    }

    public static final SQLDialect getSQLDialect(Connection connection) throws SQLException {
        return SQLDialectFactory.getSQLDialect(connection.getMetaData());
    }

    public static final SQLDialect getSQLDialect(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            SQLDialect sQLDialect = SQLDialectFactory.getSQLDialect(connection);
            return sQLDialect;
        }
    }
}

