/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

package org.clazzes.util.sql.helper;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StatementFiller {
    private PreparedStatement statement;
    private int currIndex = 1;

    public StatementFiller(PreparedStatement statement) {
        this.statement = statement;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public int getCurrIndex() {
        return this.currIndex;
    }

    public StatementFiller addLong(Number l) throws SQLException {
        JDBCHelper.setLong(this.statement, this.currIndex++, l);
        return this;
    }

    public StatementFiller addInt(Number l) throws SQLException {
        JDBCHelper.setInt(this.statement, this.currIndex++, l);
        return this;
    }

    public StatementFiller addDouble(Number l) throws SQLException {
        JDBCHelper.setDouble(this.statement, this.currIndex++, l);
        return this;
    }

    public StatementFiller addString(String s) throws SQLException {
        this.statement.setString(this.currIndex++, s);
        return this;
    }

    public StatementFiller checkNumberOfWildcards(String sql) {
        QueryHelper.checkNumberOfWildcards(sql, this.currIndex);
        return this;
    }
}
