/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.ha;

/**
 * A concurrent lock across multiple HA node.
 */
public interface IHaLock extends AutoCloseable {

    /**
     * @return The subsystem used for cross-node locking.
     */
    public String getSubSystem();

    /**
     * @return Our node name under which we have currently locked the subsystem.
     */
    public String getNodeName();

    /**
     * @return The time, when we locked the subsystem.
     */
    public long getLockTime();
    
    /**
     * @return The name of the last node, which locked this subsystem or
     *         <code>null</code>, if this subsystem has never been locked.
     */
    public String getLastNodeName();

    /**
     * @return The last time this subsystem has been locked.
     *         This value is only valid, if {@link #getLastNodeName()}
     *         returns not <code>null</code>.
     */
    public long getLastLockTime();
    
    /**
     * @return The last time this subsystem has been unlocked.
     *         This value is only valid, if {@link #getLastNodeName()}
     *         returns not <code>null</code>.
     */
    public long getLastUnlockTime();
}
