/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.dao;

/**
 * <p>A callback, which receives objects during the traversal of
 * an SQL result set.</p>
 * 
 * <p>Typical implementations write the entity to a stream or
 * collect entities in a list or a map.</p>
 */
public interface IEntityConsumer<T> {

    /**
     * Process the next entity received as part of a result set.
     * 
     * @param entity The entity to consume.
     * @throws Exception An exception like an IOException,
     *        which might occur, when the entity is processed. 
     */
    void consumeEntity(T entity) throws Exception;
}
