/***********************************************************
 * $Id$
 * 
 * SQL/DAO utilities of clazzes.org
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.util.sql.criteria;

import org.clazzes.util.sql.SQLDialect;
import org.clazzes.util.sql.SQLFragment;

/**
 * @author cl
 *
 */
public class SQLOrder implements SQLFragment {

  public enum OrderDirection {
    ASC,
    DESC
  }

  private static final long serialVersionUID = 2012021401L;

  private SQLFragment fragment;

  private OrderDirection order;


  protected SQLOrder(SQLFragment fragment, OrderDirection order) {
    super();
    this.fragment = fragment;
    this.order = order;
  }

  
  public static SQLOrder forFragment(SQLFragment fragment, OrderDirection order) {
    return new SQLOrder(fragment, order);
  }

  public static SQLOrder forTableColumn(String tableName, String columnName, OrderDirection order) {
    SQLFragment f = SQLValue.tableColumn(tableName, columnName);
    return new SQLOrder(f, order);
  }


  /* (non-Javadoc)
   * @see org.clazzes.util.sql.SQLFragment#toSQL(org.clazzes.util.sql.SQLDialect)
   */
  @Override
  public String toSQL(SQLDialect dialect) {
    if (this.order == null) {
      return "";
    }
    if (this.order == OrderDirection.ASC) {
      return this.fragment.toSQL(dialect)+" ASC";
    } else {
      return this.fragment.toSQL(dialect)+" DESC";
    }
  }

}
